// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/catalog_service.proto

#include "google/cloud/retail/v2/catalog_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace retail_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

CatalogServiceConnectionIdempotencyPolicy::
    ~CatalogServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<CatalogServiceConnectionIdempotencyPolicy>
CatalogServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<CatalogServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::ListCatalogs(
    google::cloud::retail::v2::ListCatalogsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::UpdateCatalog(
    google::cloud::retail::v2::UpdateCatalogRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::SetDefaultBranch(
    google::cloud::retail::v2::SetDefaultBranchRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::GetDefaultBranch(
    google::cloud::retail::v2::GetDefaultBranchRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::GetCompletionConfig(
    google::cloud::retail::v2::GetCompletionConfigRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::UpdateCompletionConfig(
    google::cloud::retail::v2::UpdateCompletionConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::GetAttributesConfig(
    google::cloud::retail::v2::GetAttributesConfigRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::UpdateAttributesConfig(
    google::cloud::retail::v2::UpdateAttributesConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::AddCatalogAttribute(
    google::cloud::retail::v2::AddCatalogAttributeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::RemoveCatalogAttribute(
    google::cloud::retail::v2::RemoveCatalogAttributeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CatalogServiceConnectionIdempotencyPolicy::ReplaceCatalogAttribute(
    google::cloud::retail::v2::ReplaceCatalogAttributeRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<CatalogServiceConnectionIdempotencyPolicy>
MakeDefaultCatalogServiceConnectionIdempotencyPolicy() {
  return std::make_unique<CatalogServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_v2
}  // namespace cloud
}  // namespace google
