// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/catalog_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_CATALOG_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_CATALOG_CLIENT_H

#include "google/cloud/retail/v2/catalog_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace retail_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service for managing catalog configuration.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class CatalogServiceClient {
 public:
  explicit CatalogServiceClient(
      std::shared_ptr<CatalogServiceConnection> connection, Options opts = {});
  ~CatalogServiceClient();

  ///@{
  /// @name Copy and move support
  CatalogServiceClient(CatalogServiceClient const&) = default;
  CatalogServiceClient& operator=(CatalogServiceClient const&) = default;
  CatalogServiceClient(CatalogServiceClient&&) = default;
  CatalogServiceClient& operator=(CatalogServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(CatalogServiceClient const& a,
                         CatalogServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(CatalogServiceClient const& a,
                         CatalogServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists all the [Catalog][google.cloud.retail.v2.Catalog]s associated with
  /// the project.
  ///
  /// @param parent  Required. The account resource name with an associated location.
  ///  @n
  ///  If the caller does not have permission to list
  ///  [Catalog][google.cloud.retail.v2.Catalog]s under this location, regardless
  ///  of whether or not this location exists, a PERMISSION_DENIED error is
  ///  returned.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.retail.v2.Catalog], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.Catalog]: @googleapis_reference_link{google/cloud/retail/v2/catalog.proto#L369}
  /// [google.cloud.retail.v2.ListCatalogsRequest]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L207}
  ///
  // clang-format on
  StreamRange<google::cloud::retail::v2::Catalog> ListCatalogs(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all the [Catalog][google.cloud.retail.v2.Catalog]s associated with
  /// the project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.retail.v2.ListCatalogsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.retail.v2.Catalog], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.Catalog]: @googleapis_reference_link{google/cloud/retail/v2/catalog.proto#L369}
  /// [google.cloud.retail.v2.ListCatalogsRequest]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L207}
  ///
  // clang-format on
  StreamRange<google::cloud::retail::v2::Catalog> ListCatalogs(
      google::cloud::retail::v2::ListCatalogsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the [Catalog][google.cloud.retail.v2.Catalog]s.
  ///
  /// @param catalog  Required. The [Catalog][google.cloud.retail.v2.Catalog] to update.
  ///  @n
  ///  If the caller does not have permission to update the
  ///  [Catalog][google.cloud.retail.v2.Catalog], regardless of whether or not it
  ///  exists, a PERMISSION_DENIED error is returned.
  ///  @n
  ///  If the [Catalog][google.cloud.retail.v2.Catalog] to update does not exist,
  ///  a NOT_FOUND error is returned.
  /// @param update_mask  Indicates which fields in the provided
  ///  [Catalog][google.cloud.retail.v2.Catalog] to update.
  ///  @n
  ///  If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
  ///  is returned.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.Catalog])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.Catalog]: @googleapis_reference_link{google/cloud/retail/v2/catalog.proto#L369}
  /// [google.cloud.retail.v2.UpdateCatalogRequest]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L258}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::Catalog> UpdateCatalog(
      google::cloud::retail::v2::Catalog const& catalog,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the [Catalog][google.cloud.retail.v2.Catalog]s.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.retail.v2.UpdateCatalogRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.Catalog])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.Catalog]: @googleapis_reference_link{google/cloud/retail/v2/catalog.proto#L369}
  /// [google.cloud.retail.v2.UpdateCatalogRequest]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L258}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::Catalog> UpdateCatalog(
      google::cloud::retail::v2::UpdateCatalogRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Set a specified branch id as default branch. API methods such as
  /// [SearchService.Search][google.cloud.retail.v2.SearchService.Search],
  /// [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct],
  /// [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts]
  /// will treat requests using "default_branch" to the actual branch id set as
  /// default.
  ///
  /// For example, if `projects/*/locations/*/catalogs/*/branches/1` is set as
  /// default, setting
  /// [SearchRequest.branch][google.cloud.retail.v2.SearchRequest.branch] to
  /// `projects/*/locations/*/catalogs/*/branches/default_branch` is equivalent
  /// to setting
  /// [SearchRequest.branch][google.cloud.retail.v2.SearchRequest.branch] to
  /// `projects/*/locations/*/catalogs/*/branches/1`.
  ///
  /// Using multiple branches can be useful when developers would like
  /// to have a staging branch to test and verify for future usage. When it
  /// becomes ready, developers switch on the staging branch using this API while
  /// keeping using `projects/*/locations/*/catalogs/*/branches/default_branch`
  /// as [SearchRequest.branch][google.cloud.retail.v2.SearchRequest.branch] to
  /// route the traffic to this staging branch.
  ///
  /// CAUTION: If you have live predict/search traffic, switching the default
  /// branch could potentially cause outages if the ID space of the new branch is
  /// very different from the old one.
  ///
  /// More specifically:
  ///
  /// * PredictionService will only return product IDs from branch {newBranch}.
  /// * SearchService will only return product IDs from branch {newBranch}
  ///   (if branch is not explicitly set).
  /// * UserEventService will only join events with products from branch
  ///   {newBranch}.
  ///
  /// @param catalog  Full resource name of the catalog, such as
  ///  `projects/*/locations/global/catalogs/default_catalog`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.SetDefaultBranchRequest]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L278}
  ///
  // clang-format on
  Status SetDefaultBranch(std::string const& catalog, Options opts = {});

  // clang-format off
  ///
  /// Set a specified branch id as default branch. API methods such as
  /// [SearchService.Search][google.cloud.retail.v2.SearchService.Search],
  /// [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct],
  /// [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts]
  /// will treat requests using "default_branch" to the actual branch id set as
  /// default.
  ///
  /// For example, if `projects/*/locations/*/catalogs/*/branches/1` is set as
  /// default, setting
  /// [SearchRequest.branch][google.cloud.retail.v2.SearchRequest.branch] to
  /// `projects/*/locations/*/catalogs/*/branches/default_branch` is equivalent
  /// to setting
  /// [SearchRequest.branch][google.cloud.retail.v2.SearchRequest.branch] to
  /// `projects/*/locations/*/catalogs/*/branches/1`.
  ///
  /// Using multiple branches can be useful when developers would like
  /// to have a staging branch to test and verify for future usage. When it
  /// becomes ready, developers switch on the staging branch using this API while
  /// keeping using `projects/*/locations/*/catalogs/*/branches/default_branch`
  /// as [SearchRequest.branch][google.cloud.retail.v2.SearchRequest.branch] to
  /// route the traffic to this staging branch.
  ///
  /// CAUTION: If you have live predict/search traffic, switching the default
  /// branch could potentially cause outages if the ID space of the new branch is
  /// very different from the old one.
  ///
  /// More specifically:
  ///
  /// * PredictionService will only return product IDs from branch {newBranch}.
  /// * SearchService will only return product IDs from branch {newBranch}
  ///   (if branch is not explicitly set).
  /// * UserEventService will only join events with products from branch
  ///   {newBranch}.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.retail.v2.SetDefaultBranchRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.SetDefaultBranchRequest]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L278}
  ///
  // clang-format on
  Status SetDefaultBranch(
      google::cloud::retail::v2::SetDefaultBranchRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Get which branch is currently default branch set by
  /// [CatalogService.SetDefaultBranch][google.cloud.retail.v2.CatalogService.SetDefaultBranch]
  /// method under a specified parent catalog.
  ///
  /// @param catalog  The parent catalog resource name, such as
  ///  `projects/*/locations/global/catalogs/default_catalog`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.GetDefaultBranchResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.CatalogService.SetDefaultBranch]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L94}
  /// [google.cloud.retail.v2.GetDefaultBranchRequest]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L312}
  /// [google.cloud.retail.v2.GetDefaultBranchResponse]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L322}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::GetDefaultBranchResponse>
  GetDefaultBranch(std::string const& catalog, Options opts = {});

  // clang-format off
  ///
  /// Get which branch is currently default branch set by
  /// [CatalogService.SetDefaultBranch][google.cloud.retail.v2.CatalogService.SetDefaultBranch]
  /// method under a specified parent catalog.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.retail.v2.GetDefaultBranchRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.GetDefaultBranchResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.CatalogService.SetDefaultBranch]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L94}
  /// [google.cloud.retail.v2.GetDefaultBranchRequest]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L312}
  /// [google.cloud.retail.v2.GetDefaultBranchResponse]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L322}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::GetDefaultBranchResponse>
  GetDefaultBranch(
      google::cloud::retail::v2::GetDefaultBranchRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a [CompletionConfig][google.cloud.retail.v2.CompletionConfig].
  ///
  /// @param name  Required. Full CompletionConfig resource name. Format:
  ///  `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/completionConfig`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.CompletionConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.CompletionConfig]: @googleapis_reference_link{google/cloud/retail/v2/catalog.proto#L285}
  /// [google.cloud.retail.v2.GetCompletionConfigRequest]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L340}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::CompletionConfig> GetCompletionConfig(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a [CompletionConfig][google.cloud.retail.v2.CompletionConfig].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.retail.v2.GetCompletionConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.CompletionConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.CompletionConfig]: @googleapis_reference_link{google/cloud/retail/v2/catalog.proto#L285}
  /// [google.cloud.retail.v2.GetCompletionConfigRequest]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L340}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::CompletionConfig> GetCompletionConfig(
      google::cloud::retail::v2::GetCompletionConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the [CompletionConfig][google.cloud.retail.v2.CompletionConfig]s.
  ///
  /// @param completion_config  Required. The [CompletionConfig][google.cloud.retail.v2.CompletionConfig]
  ///  to update.
  ///  @n
  ///  If the caller does not have permission to update the
  ///  [CompletionConfig][google.cloud.retail.v2.CompletionConfig], then a
  ///  PERMISSION_DENIED error is returned.
  ///  @n
  ///  If the [CompletionConfig][google.cloud.retail.v2.CompletionConfig] to
  ///  update does not exist, a NOT_FOUND error is returned.
  /// @param update_mask  Indicates which fields in the provided
  ///  [CompletionConfig][google.cloud.retail.v2.CompletionConfig] to update. The
  ///  following are the only supported fields:
  ///  @n
  ///  * [CompletionConfig.matching_order][google.cloud.retail.v2.CompletionConfig.matching_order]
  ///  * [CompletionConfig.max_suggestions][google.cloud.retail.v2.CompletionConfig.max_suggestions]
  ///  * [CompletionConfig.min_prefix_length][google.cloud.retail.v2.CompletionConfig.min_prefix_length]
  ///  * [CompletionConfig.auto_learning][google.cloud.retail.v2.CompletionConfig.auto_learning]
  ///  @n
  ///  If not set, all supported fields are updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.CompletionConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.CompletionConfig]: @googleapis_reference_link{google/cloud/retail/v2/catalog.proto#L285}
  /// [google.cloud.retail.v2.UpdateCompletionConfigRequest]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L354}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::CompletionConfig> UpdateCompletionConfig(
      google::cloud::retail::v2::CompletionConfig const& completion_config,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the [CompletionConfig][google.cloud.retail.v2.CompletionConfig]s.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.retail.v2.UpdateCompletionConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.CompletionConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.CompletionConfig]: @googleapis_reference_link{google/cloud/retail/v2/catalog.proto#L285}
  /// [google.cloud.retail.v2.UpdateCompletionConfigRequest]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L354}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::CompletionConfig> UpdateCompletionConfig(
      google::cloud::retail::v2::UpdateCompletionConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets an [AttributesConfig][google.cloud.retail.v2.AttributesConfig].
  ///
  /// @param name  Required. Full AttributesConfig resource name. Format:
  ///  `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/attributesConfig`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.AttributesConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.AttributesConfig]: @googleapis_reference_link{google/cloud/retail/v2/catalog.proto#L252}
  /// [google.cloud.retail.v2.GetAttributesConfigRequest]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L383}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::AttributesConfig> GetAttributesConfig(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets an [AttributesConfig][google.cloud.retail.v2.AttributesConfig].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.retail.v2.GetAttributesConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.AttributesConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.AttributesConfig]: @googleapis_reference_link{google/cloud/retail/v2/catalog.proto#L252}
  /// [google.cloud.retail.v2.GetAttributesConfigRequest]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L383}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::AttributesConfig> GetAttributesConfig(
      google::cloud::retail::v2::GetAttributesConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the [AttributesConfig][google.cloud.retail.v2.AttributesConfig].
  ///
  /// The catalog attributes in the request will be updated in the catalog, or
  /// inserted if they do not exist. Existing catalog attributes not included in
  /// the request will remain unchanged. Attributes that are assigned to
  /// products, but do not exist at the catalog level, are always included in the
  /// response. The product attribute is assigned default values for missing
  /// catalog attribute fields, e.g., searchable and dynamic facetable options.
  ///
  /// @param attributes_config  Required. The [AttributesConfig][google.cloud.retail.v2.AttributesConfig]
  ///  to update.
  /// @param update_mask  Indicates which fields in the provided
  ///  [AttributesConfig][google.cloud.retail.v2.AttributesConfig] to update. The
  ///  following is the only supported field:
  ///  @n
  ///  * [AttributesConfig.catalog_attributes][google.cloud.retail.v2.AttributesConfig.catalog_attributes]
  ///  @n
  ///  If not set, all supported fields are updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.AttributesConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.AttributesConfig]: @googleapis_reference_link{google/cloud/retail/v2/catalog.proto#L252}
  /// [google.cloud.retail.v2.UpdateAttributesConfigRequest]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L397}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::AttributesConfig> UpdateAttributesConfig(
      google::cloud::retail::v2::AttributesConfig const& attributes_config,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the [AttributesConfig][google.cloud.retail.v2.AttributesConfig].
  ///
  /// The catalog attributes in the request will be updated in the catalog, or
  /// inserted if they do not exist. Existing catalog attributes not included in
  /// the request will remain unchanged. Attributes that are assigned to
  /// products, but do not exist at the catalog level, are always included in the
  /// response. The product attribute is assigned default values for missing
  /// catalog attribute fields, e.g., searchable and dynamic facetable options.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.retail.v2.UpdateAttributesConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.AttributesConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.AttributesConfig]: @googleapis_reference_link{google/cloud/retail/v2/catalog.proto#L252}
  /// [google.cloud.retail.v2.UpdateAttributesConfigRequest]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L397}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::AttributesConfig> UpdateAttributesConfig(
      google::cloud::retail::v2::UpdateAttributesConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Adds the specified
  /// [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] to the
  /// [AttributesConfig][google.cloud.retail.v2.AttributesConfig].
  ///
  /// If the [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] to add
  /// already exists, an ALREADY_EXISTS error is returned.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.retail.v2.AddCatalogAttributeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.AttributesConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.AddCatalogAttributeRequest]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L416}
  /// [google.cloud.retail.v2.AttributesConfig]: @googleapis_reference_link{google/cloud/retail/v2/catalog.proto#L252}
  /// [google.cloud.retail.v2.CatalogAttribute]: @googleapis_reference_link{google/cloud/retail/v2/catalog.proto#L89}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::AttributesConfig> AddCatalogAttribute(
      google::cloud::retail::v2::AddCatalogAttributeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Removes the specified
  /// [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] from the
  /// [AttributesConfig][google.cloud.retail.v2.AttributesConfig].
  ///
  /// If the [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] to
  /// remove does not exist, a NOT_FOUND error is returned.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.retail.v2.RemoveCatalogAttributeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.AttributesConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.AttributesConfig]: @googleapis_reference_link{google/cloud/retail/v2/catalog.proto#L252}
  /// [google.cloud.retail.v2.CatalogAttribute]: @googleapis_reference_link{google/cloud/retail/v2/catalog.proto#L89}
  /// [google.cloud.retail.v2.RemoveCatalogAttributeRequest]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L435}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::AttributesConfig> RemoveCatalogAttribute(
      google::cloud::retail::v2::RemoveCatalogAttributeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Replaces the specified
  /// [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] in the
  /// [AttributesConfig][google.cloud.retail.v2.AttributesConfig] by updating the
  /// catalog attribute with the same
  /// [CatalogAttribute.key][google.cloud.retail.v2.CatalogAttribute.key].
  ///
  /// If the [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] to
  /// replace does not exist, a NOT_FOUND error is returned.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.retail.v2.ReplaceCatalogAttributeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.retail.v2.AttributesConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.retail.v2.AttributesConfig]: @googleapis_reference_link{google/cloud/retail/v2/catalog.proto#L252}
  /// [google.cloud.retail.v2.CatalogAttribute]: @googleapis_reference_link{google/cloud/retail/v2/catalog.proto#L89}
  /// [google.cloud.retail.v2.CatalogAttribute.key]: @googleapis_reference_link{google/cloud/retail/v2/catalog.proto#L176}
  /// [google.cloud.retail.v2.ReplaceCatalogAttributeRequest]: @googleapis_reference_link{google/cloud/retail/v2/catalog_service.proto#L453}
  ///
  // clang-format on
  StatusOr<google::cloud::retail::v2::AttributesConfig> ReplaceCatalogAttribute(
      google::cloud::retail::v2::ReplaceCatalogAttributeRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<CatalogServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_v2
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_CATALOG_CLIENT_H
