// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/folders.proto

#include "google/cloud/resourcemanager/v3/folders_client.h"
#include "google/cloud/resourcemanager/v3/folders_options.h"
#include <memory>
#include <thread>

namespace google {
namespace cloud {
namespace resourcemanager_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

FoldersClient::FoldersClient(std::shared_ptr<FoldersConnection> connection,
                             Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
FoldersClient::~FoldersClient() = default;

StatusOr<google::cloud::resourcemanager::v3::Folder> FoldersClient::GetFolder(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::GetFolderRequest request;
  request.set_name(name);
  return connection_->GetFolder(request);
}

StatusOr<google::cloud::resourcemanager::v3::Folder> FoldersClient::GetFolder(
    google::cloud::resourcemanager::v3::GetFolderRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetFolder(request);
}

StreamRange<google::cloud::resourcemanager::v3::Folder>
FoldersClient::ListFolders(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::ListFoldersRequest request;
  request.set_parent(parent);
  return connection_->ListFolders(request);
}

StreamRange<google::cloud::resourcemanager::v3::Folder>
FoldersClient::ListFolders(
    google::cloud::resourcemanager::v3::ListFoldersRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListFolders(std::move(request));
}

StreamRange<google::cloud::resourcemanager::v3::Folder>
FoldersClient::SearchFolders(std::string const& query, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::SearchFoldersRequest request;
  request.set_query(query);
  return connection_->SearchFolders(request);
}

StreamRange<google::cloud::resourcemanager::v3::Folder>
FoldersClient::SearchFolders(
    google::cloud::resourcemanager::v3::SearchFoldersRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SearchFolders(std::move(request));
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersClient::CreateFolder(
    google::cloud::resourcemanager::v3::Folder const& folder, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::CreateFolderRequest request;
  *request.mutable_folder() = folder;
  return connection_->CreateFolder(request);
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersClient::CreateFolder(
    google::cloud::resourcemanager::v3::CreateFolderRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateFolder(request);
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersClient::UpdateFolder(
    google::cloud::resourcemanager::v3::Folder const& folder,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::UpdateFolderRequest request;
  *request.mutable_folder() = folder;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateFolder(request);
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersClient::UpdateFolder(
    google::cloud::resourcemanager::v3::UpdateFolderRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateFolder(request);
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersClient::MoveFolder(std::string const& name,
                          std::string const& destination_parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::MoveFolderRequest request;
  request.set_name(name);
  request.set_destination_parent(destination_parent);
  return connection_->MoveFolder(request);
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersClient::MoveFolder(
    google::cloud::resourcemanager::v3::MoveFolderRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->MoveFolder(request);
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersClient::DeleteFolder(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::DeleteFolderRequest request;
  request.set_name(name);
  return connection_->DeleteFolder(request);
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersClient::DeleteFolder(
    google::cloud::resourcemanager::v3::DeleteFolderRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteFolder(request);
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersClient::UndeleteFolder(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::UndeleteFolderRequest request;
  request.set_name(name);
  return connection_->UndeleteFolder(request);
}

future<StatusOr<google::cloud::resourcemanager::v3::Folder>>
FoldersClient::UndeleteFolder(
    google::cloud::resourcemanager::v3::UndeleteFolderRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UndeleteFolder(request);
}

StatusOr<google::iam::v1::Policy> FoldersClient::GetIamPolicy(
    std::string const& resource, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::iam::v1::GetIamPolicyRequest request;
  request.set_resource(resource);
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> FoldersClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> FoldersClient::SetIamPolicy(
    std::string const& resource, google::iam::v1::Policy const& policy,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::iam::v1::SetIamPolicyRequest request;
  request.set_resource(resource);
  *request.mutable_policy() = policy;
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> FoldersClient::SetIamPolicy(
    std::string const& resource, IamUpdater const& updater, Options opts) {
  internal::CheckExpectedOptions<FoldersBackoffPolicyOption>(opts, __func__);
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::iam::v1::GetIamPolicyRequest get_request;
  get_request.set_resource(resource);
  google::iam::v1::SetIamPolicyRequest set_request;
  set_request.set_resource(resource);
  auto backoff_policy =
      internal::CurrentOptions().get<FoldersBackoffPolicyOption>();
  if (backoff_policy != nullptr) {
    backoff_policy = backoff_policy->clone();
  }
  for (;;) {
    auto recent = connection_->GetIamPolicy(get_request);
    if (!recent) {
      return recent.status();
    }
    auto policy = updater(*std::move(recent));
    if (!policy) {
      return Status(StatusCode::kCancelled, "updater did not yield a policy");
    }
    *set_request.mutable_policy() = *std::move(policy);
    auto result = connection_->SetIamPolicy(set_request);
    if (result || result.status().code() != StatusCode::kAborted ||
        backoff_policy == nullptr) {
      return result;
    }
    std::this_thread::sleep_for(backoff_policy->OnCompletion());
  }
}

StatusOr<google::iam::v1::Policy> FoldersClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
FoldersClient::TestIamPermissions(std::string const& resource,
                                  std::vector<std::string> const& permissions,
                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::iam::v1::TestIamPermissionsRequest request;
  request.set_resource(resource);
  *request.mutable_permissions() = {permissions.begin(), permissions.end()};
  return connection_->TestIamPermissions(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
FoldersClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_v3
}  // namespace cloud
}  // namespace google
