// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/osconfig/v1/osconfig_zonal_service.proto

#include "google/cloud/osconfig/v1/os_config_zonal_connection.h"
#include "google/cloud/osconfig/v1/internal/os_config_zonal_connection_impl.h"
#include "google/cloud/osconfig/v1/internal/os_config_zonal_option_defaults.h"
#include "google/cloud/osconfig/v1/internal/os_config_zonal_stub_factory.h"
#include "google/cloud/osconfig/v1/internal/os_config_zonal_tracing_connection.h"
#include "google/cloud/osconfig/v1/os_config_zonal_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace osconfig_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

OsConfigZonalServiceConnection::~OsConfigZonalServiceConnection() = default;

future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>
OsConfigZonalServiceConnection::CreateOSPolicyAssignment(
    google::cloud::osconfig::v1::CreateOSPolicyAssignmentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>
OsConfigZonalServiceConnection::UpdateOSPolicyAssignment(
    google::cloud::osconfig::v1::UpdateOSPolicyAssignmentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>
OsConfigZonalServiceConnection::GetOSPolicyAssignment(
    google::cloud::osconfig::v1::GetOSPolicyAssignmentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::osconfig::v1::OSPolicyAssignment>
OsConfigZonalServiceConnection::ListOSPolicyAssignments(
    google::cloud::osconfig::v1::
        ListOSPolicyAssignmentsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::osconfig::v1::OSPolicyAssignment>>();
}

StreamRange<google::cloud::osconfig::v1::OSPolicyAssignment>
OsConfigZonalServiceConnection::ListOSPolicyAssignmentRevisions(
    google::cloud::osconfig::v1::
        ListOSPolicyAssignmentRevisionsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::osconfig::v1::OSPolicyAssignment>>();
}

future<
    StatusOr<google::cloud::osconfig::v1::OSPolicyAssignmentOperationMetadata>>
OsConfigZonalServiceConnection::DeleteOSPolicyAssignment(
    google::cloud::osconfig::v1::DeleteOSPolicyAssignmentRequest const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::cloud::osconfig::v1::OSPolicyAssignmentOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::osconfig::v1::OSPolicyAssignmentReport>
OsConfigZonalServiceConnection::GetOSPolicyAssignmentReport(
    google::cloud::osconfig::v1::GetOSPolicyAssignmentReportRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::osconfig::v1::OSPolicyAssignmentReport>
OsConfigZonalServiceConnection::ListOSPolicyAssignmentReports(
    google::cloud::osconfig::v1::
        ListOSPolicyAssignmentReportsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::osconfig::v1::OSPolicyAssignmentReport>>();
}

StatusOr<google::cloud::osconfig::v1::Inventory>
OsConfigZonalServiceConnection::GetInventory(
    google::cloud::osconfig::v1::GetInventoryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::osconfig::v1::Inventory>
OsConfigZonalServiceConnection::ListInventories(
    google::cloud::osconfig::v1::
        ListInventoriesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::osconfig::v1::Inventory>>();
}

StatusOr<google::cloud::osconfig::v1::VulnerabilityReport>
OsConfigZonalServiceConnection::GetVulnerabilityReport(
    google::cloud::osconfig::v1::GetVulnerabilityReportRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::osconfig::v1::VulnerabilityReport>
OsConfigZonalServiceConnection::ListVulnerabilityReports(
    google::cloud::osconfig::v1::
        ListVulnerabilityReportsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::osconfig::v1::VulnerabilityReport>>();
}

std::shared_ptr<OsConfigZonalServiceConnection>
MakeOsConfigZonalServiceConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 OsConfigZonalServicePolicyOptionList>(
      options, __func__);
  options = osconfig_v1_internal::OsConfigZonalServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = osconfig_v1_internal::CreateDefaultOsConfigZonalServiceStub(
      background->cq(), options);
  return osconfig_v1_internal::MakeOsConfigZonalServiceTracingConnection(
      std::make_shared<
          osconfig_v1_internal::OsConfigZonalServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig_v1
}  // namespace cloud
}  // namespace google
