// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/osconfig/v1/osconfig_zonal_service.proto

#include "google/cloud/osconfig/v1/internal/os_config_zonal_option_defaults.h"
#include "google/cloud/osconfig/v1/os_config_zonal_connection.h"
#include "google/cloud/osconfig/v1/os_config_zonal_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace osconfig_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options OsConfigZonalServiceDefaultOptions(Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_OS_CONFIG_ZONAL_SERVICE_ENDPOINT",
      "", "GOOGLE_CLOUD_CPP_OS_CONFIG_ZONAL_SERVICE_AUTHORITY",
      "osconfig.googleapis.com");
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options.has<osconfig_v1::OsConfigZonalServiceRetryPolicyOption>()) {
    options.set<osconfig_v1::OsConfigZonalServiceRetryPolicyOption>(
        osconfig_v1::OsConfigZonalServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<osconfig_v1::OsConfigZonalServiceBackoffPolicyOption>()) {
    options.set<osconfig_v1::OsConfigZonalServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<osconfig_v1::OsConfigZonalServicePollingPolicyOption>()) {
    options.set<osconfig_v1::OsConfigZonalServicePollingPolicyOption>(
        GenericPollingPolicy<
            osconfig_v1::OsConfigZonalServiceRetryPolicyOption::Type,
            osconfig_v1::OsConfigZonalServiceBackoffPolicyOption::Type>(
            options.get<osconfig_v1::OsConfigZonalServiceRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options
           .has<osconfig_v1::
                    OsConfigZonalServiceConnectionIdempotencyPolicyOption>()) {
    options.set<
        osconfig_v1::OsConfigZonalServiceConnectionIdempotencyPolicyOption>(
        osconfig_v1::
            MakeDefaultOsConfigZonalServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig_v1_internal
}  // namespace cloud
}  // namespace google
