// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/service_service.proto

#include "google/cloud/monitoring/v3/internal/service_monitoring_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ServiceMonitoringServiceTracingStub::ServiceMonitoringServiceTracingStub(
    std::shared_ptr<ServiceMonitoringServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::monitoring::v3::Service>
ServiceMonitoringServiceTracingStub::CreateService(
    grpc::ClientContext& context,
    google::monitoring::v3::CreateServiceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.monitoring.v3.ServiceMonitoringService", "CreateService");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateService(context, request));
}

StatusOr<google::monitoring::v3::Service>
ServiceMonitoringServiceTracingStub::GetService(
    grpc::ClientContext& context,
    google::monitoring::v3::GetServiceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.monitoring.v3.ServiceMonitoringService", "GetService");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetService(context, request));
}

StatusOr<google::monitoring::v3::ListServicesResponse>
ServiceMonitoringServiceTracingStub::ListServices(
    grpc::ClientContext& context,
    google::monitoring::v3::ListServicesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.monitoring.v3.ServiceMonitoringService", "ListServices");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListServices(context, request));
}

StatusOr<google::monitoring::v3::Service>
ServiceMonitoringServiceTracingStub::UpdateService(
    grpc::ClientContext& context,
    google::monitoring::v3::UpdateServiceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.monitoring.v3.ServiceMonitoringService", "UpdateService");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateService(context, request));
}

Status ServiceMonitoringServiceTracingStub::DeleteService(
    grpc::ClientContext& context,
    google::monitoring::v3::DeleteServiceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.monitoring.v3.ServiceMonitoringService", "DeleteService");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteService(context, request));
}

StatusOr<google::monitoring::v3::ServiceLevelObjective>
ServiceMonitoringServiceTracingStub::CreateServiceLevelObjective(
    grpc::ClientContext& context,
    google::monitoring::v3::CreateServiceLevelObjectiveRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.monitoring.v3.ServiceMonitoringService",
                             "CreateServiceLevelObjective");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->CreateServiceLevelObjective(context, request));
}

StatusOr<google::monitoring::v3::ServiceLevelObjective>
ServiceMonitoringServiceTracingStub::GetServiceLevelObjective(
    grpc::ClientContext& context,
    google::monitoring::v3::GetServiceLevelObjectiveRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.monitoring.v3.ServiceMonitoringService",
                             "GetServiceLevelObjective");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetServiceLevelObjective(context, request));
}

StatusOr<google::monitoring::v3::ListServiceLevelObjectivesResponse>
ServiceMonitoringServiceTracingStub::ListServiceLevelObjectives(
    grpc::ClientContext& context,
    google::monitoring::v3::ListServiceLevelObjectivesRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.monitoring.v3.ServiceMonitoringService",
                             "ListServiceLevelObjectives");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListServiceLevelObjectives(context, request));
}

StatusOr<google::monitoring::v3::ServiceLevelObjective>
ServiceMonitoringServiceTracingStub::UpdateServiceLevelObjective(
    grpc::ClientContext& context,
    google::monitoring::v3::UpdateServiceLevelObjectiveRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.monitoring.v3.ServiceMonitoringService",
                             "UpdateServiceLevelObjective");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UpdateServiceLevelObjective(context, request));
}

Status ServiceMonitoringServiceTracingStub::DeleteServiceLevelObjective(
    grpc::ClientContext& context,
    google::monitoring::v3::DeleteServiceLevelObjectiveRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.monitoring.v3.ServiceMonitoringService",
                             "DeleteServiceLevelObjective");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->DeleteServiceLevelObjective(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<ServiceMonitoringServiceStub>
MakeServiceMonitoringServiceTracingStub(
    std::shared_ptr<ServiceMonitoringServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<ServiceMonitoringServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google
