// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/alert_service.proto

#include "google/cloud/monitoring/v3/alert_policy_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AlertPolicyServiceClient::AlertPolicyServiceClient(
    std::shared_ptr<AlertPolicyServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
AlertPolicyServiceClient::~AlertPolicyServiceClient() = default;

StreamRange<google::monitoring::v3::AlertPolicy>
AlertPolicyServiceClient::ListAlertPolicies(std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::monitoring::v3::ListAlertPoliciesRequest request;
  request.set_name(name);
  return connection_->ListAlertPolicies(request);
}

StreamRange<google::monitoring::v3::AlertPolicy>
AlertPolicyServiceClient::ListAlertPolicies(
    google::monitoring::v3::ListAlertPoliciesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListAlertPolicies(std::move(request));
}

StatusOr<google::monitoring::v3::AlertPolicy>
AlertPolicyServiceClient::GetAlertPolicy(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::monitoring::v3::GetAlertPolicyRequest request;
  request.set_name(name);
  return connection_->GetAlertPolicy(request);
}

StatusOr<google::monitoring::v3::AlertPolicy>
AlertPolicyServiceClient::GetAlertPolicy(
    google::monitoring::v3::GetAlertPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetAlertPolicy(request);
}

StatusOr<google::monitoring::v3::AlertPolicy>
AlertPolicyServiceClient::CreateAlertPolicy(
    std::string const& name,
    google::monitoring::v3::AlertPolicy const& alert_policy, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::monitoring::v3::CreateAlertPolicyRequest request;
  request.set_name(name);
  *request.mutable_alert_policy() = alert_policy;
  return connection_->CreateAlertPolicy(request);
}

StatusOr<google::monitoring::v3::AlertPolicy>
AlertPolicyServiceClient::CreateAlertPolicy(
    google::monitoring::v3::CreateAlertPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAlertPolicy(request);
}

Status AlertPolicyServiceClient::DeleteAlertPolicy(std::string const& name,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::monitoring::v3::DeleteAlertPolicyRequest request;
  request.set_name(name);
  return connection_->DeleteAlertPolicy(request);
}

Status AlertPolicyServiceClient::DeleteAlertPolicy(
    google::monitoring::v3::DeleteAlertPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAlertPolicy(request);
}

StatusOr<google::monitoring::v3::AlertPolicy>
AlertPolicyServiceClient::UpdateAlertPolicy(
    google::protobuf::FieldMask const& update_mask,
    google::monitoring::v3::AlertPolicy const& alert_policy, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::monitoring::v3::UpdateAlertPolicyRequest request;
  *request.mutable_update_mask() = update_mask;
  *request.mutable_alert_policy() = alert_policy;
  return connection_->UpdateAlertPolicy(request);
}

StatusOr<google::monitoring::v3::AlertPolicy>
AlertPolicyServiceClient::UpdateAlertPolicy(
    google::monitoring::v3::UpdateAlertPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateAlertPolicy(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3
}  // namespace cloud
}  // namespace google
