// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/dashboard/v1/dashboards_service.proto

#include "google/cloud/monitoring/dashboard/v1/dashboards_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_dashboard_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DashboardsServiceClient::DashboardsServiceClient(
    std::shared_ptr<DashboardsServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
DashboardsServiceClient::~DashboardsServiceClient() = default;

StatusOr<google::monitoring::dashboard::v1::Dashboard>
DashboardsServiceClient::CreateDashboard(
    google::monitoring::dashboard::v1::CreateDashboardRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDashboard(request);
}

StreamRange<google::monitoring::dashboard::v1::Dashboard>
DashboardsServiceClient::ListDashboards(
    google::monitoring::dashboard::v1::ListDashboardsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDashboards(std::move(request));
}

StatusOr<google::monitoring::dashboard::v1::Dashboard>
DashboardsServiceClient::GetDashboard(
    google::monitoring::dashboard::v1::GetDashboardRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDashboard(request);
}

Status DashboardsServiceClient::DeleteDashboard(
    google::monitoring::dashboard::v1::DeleteDashboardRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDashboard(request);
}

StatusOr<google::monitoring::dashboard::v1::Dashboard>
DashboardsServiceClient::UpdateDashboard(
    google::monitoring::dashboard::v1::UpdateDashboardRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDashboard(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_dashboard_v1
}  // namespace cloud
}  // namespace google
