// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkebackup/v1/gkebackup.proto

#include "google/cloud/gkebackup/v1/internal/backup_for_gke_option_defaults.h"
#include "google/cloud/gkebackup/v1/backup_for_gke_connection.h"
#include "google/cloud/gkebackup/v1/backup_for_gke_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace gkebackup_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options BackupForGKEDefaultOptions(Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_BACKUP_FOR_GKE_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_BACKUP_FOR_GKE_AUTHORITY", "gkebackup.googleapis.com");
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options.has<gkebackup_v1::BackupForGKERetryPolicyOption>()) {
    options.set<gkebackup_v1::BackupForGKERetryPolicyOption>(
        gkebackup_v1::BackupForGKELimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<gkebackup_v1::BackupForGKEBackoffPolicyOption>()) {
    options.set<gkebackup_v1::BackupForGKEBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<gkebackup_v1::BackupForGKEPollingPolicyOption>()) {
    options.set<gkebackup_v1::BackupForGKEPollingPolicyOption>(
        GenericPollingPolicy<
            gkebackup_v1::BackupForGKERetryPolicyOption::Type,
            gkebackup_v1::BackupForGKEBackoffPolicyOption::Type>(
            options.get<gkebackup_v1::BackupForGKERetryPolicyOption>()->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<
          gkebackup_v1::BackupForGKEConnectionIdempotencyPolicyOption>()) {
    options.set<gkebackup_v1::BackupForGKEConnectionIdempotencyPolicyOption>(
        gkebackup_v1::MakeDefaultBackupForGKEConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkebackup_v1_internal
}  // namespace cloud
}  // namespace google
