// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/essentialcontacts/v1/service.proto

#include "google/cloud/essentialcontacts/v1/internal/essential_contacts_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/essentialcontacts/v1/service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace essentialcontacts_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EssentialContactsServiceLogging::EssentialContactsServiceLogging(
    std::shared_ptr<EssentialContactsServiceStub> child,
    TracingOptions tracing_options, std::set<std::string> const& components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      stream_logging_(components.find("rpc-streams") != components.end()) {}

StatusOr<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceLogging::CreateContact(
    grpc::ClientContext& context,
    google::cloud::essentialcontacts::v1::CreateContactRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::essentialcontacts::v1::CreateContactRequest const&
                 request) { return child_->CreateContact(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceLogging::UpdateContact(
    grpc::ClientContext& context,
    google::cloud::essentialcontacts::v1::UpdateContactRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::essentialcontacts::v1::UpdateContactRequest const&
                 request) { return child_->UpdateContact(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::essentialcontacts::v1::ListContactsResponse>
EssentialContactsServiceLogging::ListContacts(
    grpc::ClientContext& context,
    google::cloud::essentialcontacts::v1::ListContactsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::essentialcontacts::v1::ListContactsRequest const&
                 request) { return child_->ListContacts(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceLogging::GetContact(
    grpc::ClientContext& context,
    google::cloud::essentialcontacts::v1::GetContactRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::essentialcontacts::v1::GetContactRequest const&
                 request) { return child_->GetContact(context, request); },
      context, request, __func__, tracing_options_);
}

Status EssentialContactsServiceLogging::DeleteContact(
    grpc::ClientContext& context,
    google::cloud::essentialcontacts::v1::DeleteContactRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::essentialcontacts::v1::DeleteContactRequest const&
                 request) { return child_->DeleteContact(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::essentialcontacts::v1::ComputeContactsResponse>
EssentialContactsServiceLogging::ComputeContacts(
    grpc::ClientContext& context,
    google::cloud::essentialcontacts::v1::ComputeContactsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::essentialcontacts::v1::ComputeContactsRequest const&
                 request) { return child_->ComputeContacts(context, request); },
      context, request, __func__, tracing_options_);
}

Status EssentialContactsServiceLogging::SendTestMessage(
    grpc::ClientContext& context,
    google::cloud::essentialcontacts::v1::SendTestMessageRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::essentialcontacts::v1::SendTestMessageRequest const&
                 request) { return child_->SendTestMessage(context, request); },
      context, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace essentialcontacts_v1_internal
}  // namespace cloud
}  // namespace google
