// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/edgenetwork/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EDGENETWORK_V1_INTERNAL_EDGE_NETWORK_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EDGENETWORK_V1_INTERNAL_EDGE_NETWORK_STUB_H

#include "google/cloud/completion_queue.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/edgenetwork/v1/service.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace edgenetwork_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class EdgeNetworkStub {
 public:
  virtual ~EdgeNetworkStub() = 0;

  virtual StatusOr<google::cloud::edgenetwork::v1::InitializeZoneResponse>
  InitializeZone(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::InitializeZoneRequest const& request) = 0;

  virtual StatusOr<google::cloud::edgenetwork::v1::ListZonesResponse> ListZones(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::ListZonesRequest const& request) = 0;

  virtual StatusOr<google::cloud::edgenetwork::v1::Zone> GetZone(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::GetZoneRequest const& request) = 0;

  virtual StatusOr<google::cloud::edgenetwork::v1::ListNetworksResponse>
  ListNetworks(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::ListNetworksRequest const& request) = 0;

  virtual StatusOr<google::cloud::edgenetwork::v1::Network> GetNetwork(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::GetNetworkRequest const& request) = 0;

  virtual StatusOr<google::cloud::edgenetwork::v1::DiagnoseNetworkResponse>
  DiagnoseNetwork(grpc::ClientContext& context,
                  google::cloud::edgenetwork::v1::DiagnoseNetworkRequest const&
                      request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncCreateNetwork(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::edgenetwork::v1::CreateNetworkRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncDeleteNetwork(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::edgenetwork::v1::DeleteNetworkRequest const& request) = 0;

  virtual StatusOr<google::cloud::edgenetwork::v1::ListSubnetsResponse>
  ListSubnets(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::ListSubnetsRequest const& request) = 0;

  virtual StatusOr<google::cloud::edgenetwork::v1::Subnet> GetSubnet(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::GetSubnetRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncCreateSubnet(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::edgenetwork::v1::CreateSubnetRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncUpdateSubnet(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::edgenetwork::v1::UpdateSubnetRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncDeleteSubnet(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::edgenetwork::v1::DeleteSubnetRequest const& request) = 0;

  virtual StatusOr<google::cloud::edgenetwork::v1::ListInterconnectsResponse>
  ListInterconnects(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::ListInterconnectsRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::edgenetwork::v1::Interconnect>
  GetInterconnect(grpc::ClientContext& context,
                  google::cloud::edgenetwork::v1::GetInterconnectRequest const&
                      request) = 0;

  virtual StatusOr<google::cloud::edgenetwork::v1::DiagnoseInterconnectResponse>
  DiagnoseInterconnect(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::DiagnoseInterconnectRequest const&
          request) = 0;

  virtual StatusOr<
      google::cloud::edgenetwork::v1::ListInterconnectAttachmentsResponse>
  ListInterconnectAttachments(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::ListInterconnectAttachmentsRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::edgenetwork::v1::InterconnectAttachment>
  GetInterconnectAttachment(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::GetInterconnectAttachmentRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncCreateInterconnectAttachment(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::edgenetwork::v1::CreateInterconnectAttachmentRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncDeleteInterconnectAttachment(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::edgenetwork::v1::DeleteInterconnectAttachmentRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::edgenetwork::v1::ListRoutersResponse>
  ListRouters(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::ListRoutersRequest const& request) = 0;

  virtual StatusOr<google::cloud::edgenetwork::v1::Router> GetRouter(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::GetRouterRequest const& request) = 0;

  virtual StatusOr<google::cloud::edgenetwork::v1::DiagnoseRouterResponse>
  DiagnoseRouter(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::DiagnoseRouterRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncCreateRouter(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::edgenetwork::v1::CreateRouterRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncUpdateRouter(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::edgenetwork::v1::UpdateRouterRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncDeleteRouter(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::edgenetwork::v1::DeleteRouterRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::longrunning::GetOperationRequest const& request) = 0;

  virtual future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::longrunning::CancelOperationRequest const& request) = 0;
};

class DefaultEdgeNetworkStub : public EdgeNetworkStub {
 public:
  DefaultEdgeNetworkStub(
      std::unique_ptr<
          google::cloud::edgenetwork::v1::EdgeNetwork::StubInterface>
          grpc_stub,
      std::unique_ptr<google::longrunning::Operations::StubInterface>
          operations)
      : grpc_stub_(std::move(grpc_stub)), operations_(std::move(operations)) {}

  StatusOr<google::cloud::edgenetwork::v1::InitializeZoneResponse>
  InitializeZone(grpc::ClientContext& context,
                 google::cloud::edgenetwork::v1::InitializeZoneRequest const&
                     request) override;

  StatusOr<google::cloud::edgenetwork::v1::ListZonesResponse> ListZones(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::ListZonesRequest const& request) override;

  StatusOr<google::cloud::edgenetwork::v1::Zone> GetZone(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::GetZoneRequest const& request) override;

  StatusOr<google::cloud::edgenetwork::v1::ListNetworksResponse> ListNetworks(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::ListNetworksRequest const& request)
      override;

  StatusOr<google::cloud::edgenetwork::v1::Network> GetNetwork(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::GetNetworkRequest const& request)
      override;

  StatusOr<google::cloud::edgenetwork::v1::DiagnoseNetworkResponse>
  DiagnoseNetwork(grpc::ClientContext& context,
                  google::cloud::edgenetwork::v1::DiagnoseNetworkRequest const&
                      request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateNetwork(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::edgenetwork::v1::CreateNetworkRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteNetwork(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::edgenetwork::v1::DeleteNetworkRequest const& request)
      override;

  StatusOr<google::cloud::edgenetwork::v1::ListSubnetsResponse> ListSubnets(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::ListSubnetsRequest const& request)
      override;

  StatusOr<google::cloud::edgenetwork::v1::Subnet> GetSubnet(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::GetSubnetRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateSubnet(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::edgenetwork::v1::CreateSubnetRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateSubnet(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::edgenetwork::v1::UpdateSubnetRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteSubnet(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::edgenetwork::v1::DeleteSubnetRequest const& request)
      override;

  StatusOr<google::cloud::edgenetwork::v1::ListInterconnectsResponse>
  ListInterconnects(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::ListInterconnectsRequest const& request)
      override;

  StatusOr<google::cloud::edgenetwork::v1::Interconnect> GetInterconnect(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::GetInterconnectRequest const& request)
      override;

  StatusOr<google::cloud::edgenetwork::v1::DiagnoseInterconnectResponse>
  DiagnoseInterconnect(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::DiagnoseInterconnectRequest const&
          request) override;

  StatusOr<google::cloud::edgenetwork::v1::ListInterconnectAttachmentsResponse>
  ListInterconnectAttachments(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::ListInterconnectAttachmentsRequest const&
          request) override;

  StatusOr<google::cloud::edgenetwork::v1::InterconnectAttachment>
  GetInterconnectAttachment(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::GetInterconnectAttachmentRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>>
  AsyncCreateInterconnectAttachment(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::edgenetwork::v1::CreateInterconnectAttachmentRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>>
  AsyncDeleteInterconnectAttachment(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::edgenetwork::v1::DeleteInterconnectAttachmentRequest const&
          request) override;

  StatusOr<google::cloud::edgenetwork::v1::ListRoutersResponse> ListRouters(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::ListRoutersRequest const& request)
      override;

  StatusOr<google::cloud::edgenetwork::v1::Router> GetRouter(
      grpc::ClientContext& context,
      google::cloud::edgenetwork::v1::GetRouterRequest const& request) override;

  StatusOr<google::cloud::edgenetwork::v1::DiagnoseRouterResponse>
  DiagnoseRouter(grpc::ClientContext& context,
                 google::cloud::edgenetwork::v1::DiagnoseRouterRequest const&
                     request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateRouter(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::edgenetwork::v1::CreateRouterRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateRouter(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::edgenetwork::v1::UpdateRouterRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteRouter(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::edgenetwork::v1::DeleteRouterRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::unique_ptr<google::cloud::edgenetwork::v1::EdgeNetwork::StubInterface>
      grpc_stub_;
  std::unique_ptr<google::longrunning::Operations::StubInterface> operations_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace edgenetwork_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EDGENETWORK_V1_INTERNAL_EDGE_NETWORK_STUB_H
