// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/session_entity_type.proto

#include "google/cloud/dialogflow_cx/session_entity_types_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SessionEntityTypesClient::SessionEntityTypesClient(
    std::shared_ptr<SessionEntityTypesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
SessionEntityTypesClient::~SessionEntityTypesClient() = default;

StreamRange<google::cloud::dialogflow::cx::v3::SessionEntityType>
SessionEntityTypesClient::ListSessionEntityTypes(std::string const& parent,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::ListSessionEntityTypesRequest request;
  request.set_parent(parent);
  return connection_->ListSessionEntityTypes(request);
}

StreamRange<google::cloud::dialogflow::cx::v3::SessionEntityType>
SessionEntityTypesClient::ListSessionEntityTypes(
    google::cloud::dialogflow::cx::v3::ListSessionEntityTypesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSessionEntityTypes(std::move(request));
}

StatusOr<google::cloud::dialogflow::cx::v3::SessionEntityType>
SessionEntityTypesClient::GetSessionEntityType(std::string const& name,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::GetSessionEntityTypeRequest request;
  request.set_name(name);
  return connection_->GetSessionEntityType(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::SessionEntityType>
SessionEntityTypesClient::GetSessionEntityType(
    google::cloud::dialogflow::cx::v3::GetSessionEntityTypeRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSessionEntityType(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::SessionEntityType>
SessionEntityTypesClient::CreateSessionEntityType(
    std::string const& parent,
    google::cloud::dialogflow::cx::v3::SessionEntityType const&
        session_entity_type,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::CreateSessionEntityTypeRequest request;
  request.set_parent(parent);
  *request.mutable_session_entity_type() = session_entity_type;
  return connection_->CreateSessionEntityType(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::SessionEntityType>
SessionEntityTypesClient::CreateSessionEntityType(
    google::cloud::dialogflow::cx::v3::CreateSessionEntityTypeRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSessionEntityType(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::SessionEntityType>
SessionEntityTypesClient::UpdateSessionEntityType(
    google::cloud::dialogflow::cx::v3::SessionEntityType const&
        session_entity_type,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::UpdateSessionEntityTypeRequest request;
  *request.mutable_session_entity_type() = session_entity_type;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateSessionEntityType(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::SessionEntityType>
SessionEntityTypesClient::UpdateSessionEntityType(
    google::cloud::dialogflow::cx::v3::UpdateSessionEntityTypeRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSessionEntityType(request);
}

Status SessionEntityTypesClient::DeleteSessionEntityType(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::DeleteSessionEntityTypeRequest request;
  request.set_name(name);
  return connection_->DeleteSessionEntityType(request);
}

Status SessionEntityTypesClient::DeleteSessionEntityType(
    google::cloud::dialogflow::cx::v3::DeleteSessionEntityTypeRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSessionEntityType(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google
