// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/environment.proto

#include "google/cloud/dialogflow_cx/environments_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EnvironmentsClient::EnvironmentsClient(
    std::shared_ptr<EnvironmentsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
EnvironmentsClient::~EnvironmentsClient() = default;

StreamRange<google::cloud::dialogflow::cx::v3::Environment>
EnvironmentsClient::ListEnvironments(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::ListEnvironmentsRequest request;
  request.set_parent(parent);
  return connection_->ListEnvironments(request);
}

StreamRange<google::cloud::dialogflow::cx::v3::Environment>
EnvironmentsClient::ListEnvironments(
    google::cloud::dialogflow::cx::v3::ListEnvironmentsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListEnvironments(std::move(request));
}

StatusOr<google::cloud::dialogflow::cx::v3::Environment>
EnvironmentsClient::GetEnvironment(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::GetEnvironmentRequest request;
  request.set_name(name);
  return connection_->GetEnvironment(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Environment>
EnvironmentsClient::GetEnvironment(
    google::cloud::dialogflow::cx::v3::GetEnvironmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEnvironment(request);
}

future<StatusOr<google::cloud::dialogflow::cx::v3::Environment>>
EnvironmentsClient::CreateEnvironment(
    std::string const& parent,
    google::cloud::dialogflow::cx::v3::Environment const& environment,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::CreateEnvironmentRequest request;
  request.set_parent(parent);
  *request.mutable_environment() = environment;
  return connection_->CreateEnvironment(request);
}

future<StatusOr<google::cloud::dialogflow::cx::v3::Environment>>
EnvironmentsClient::CreateEnvironment(
    google::cloud::dialogflow::cx::v3::CreateEnvironmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateEnvironment(request);
}

future<StatusOr<google::cloud::dialogflow::cx::v3::Environment>>
EnvironmentsClient::UpdateEnvironment(
    google::cloud::dialogflow::cx::v3::Environment const& environment,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::UpdateEnvironmentRequest request;
  *request.mutable_environment() = environment;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateEnvironment(request);
}

future<StatusOr<google::cloud::dialogflow::cx::v3::Environment>>
EnvironmentsClient::UpdateEnvironment(
    google::cloud::dialogflow::cx::v3::UpdateEnvironmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateEnvironment(request);
}

Status EnvironmentsClient::DeleteEnvironment(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::DeleteEnvironmentRequest request;
  request.set_name(name);
  return connection_->DeleteEnvironment(request);
}

Status EnvironmentsClient::DeleteEnvironment(
    google::cloud::dialogflow::cx::v3::DeleteEnvironmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteEnvironment(request);
}

StreamRange<google::cloud::dialogflow::cx::v3::Environment>
EnvironmentsClient::LookupEnvironmentHistory(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::LookupEnvironmentHistoryRequest request;
  request.set_name(name);
  return connection_->LookupEnvironmentHistory(request);
}

StreamRange<google::cloud::dialogflow::cx::v3::Environment>
EnvironmentsClient::LookupEnvironmentHistory(
    google::cloud::dialogflow::cx::v3::LookupEnvironmentHistoryRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->LookupEnvironmentHistory(std::move(request));
}

future<StatusOr<google::cloud::dialogflow::cx::v3::RunContinuousTestResponse>>
EnvironmentsClient::RunContinuousTest(
    google::cloud::dialogflow::cx::v3::RunContinuousTestRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RunContinuousTest(request);
}

StreamRange<google::cloud::dialogflow::cx::v3::ContinuousTestResult>
EnvironmentsClient::ListContinuousTestResults(std::string const& parent,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::ListContinuousTestResultsRequest request;
  request.set_parent(parent);
  return connection_->ListContinuousTestResults(request);
}

StreamRange<google::cloud::dialogflow::cx::v3::ContinuousTestResult>
EnvironmentsClient::ListContinuousTestResults(
    google::cloud::dialogflow::cx::v3::ListContinuousTestResultsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListContinuousTestResults(std::move(request));
}

future<StatusOr<google::cloud::dialogflow::cx::v3::DeployFlowResponse>>
EnvironmentsClient::DeployFlow(
    google::cloud::dialogflow::cx::v3::DeployFlowRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeployFlow(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google
