// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/node_groups.proto

#include "google/cloud/dataproc/v1/internal/node_group_controller_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataproc_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

NodeGroupControllerTracingConnection::NodeGroupControllerTracingConnection(
    std::shared_ptr<dataproc_v1::NodeGroupControllerConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::dataproc::v1::NodeGroup>>
NodeGroupControllerTracingConnection::CreateNodeGroup(
    google::cloud::dataproc::v1::CreateNodeGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "dataproc_v1::NodeGroupControllerConnection::CreateNodeGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateNodeGroup(request));
}

future<StatusOr<google::cloud::dataproc::v1::NodeGroup>>
NodeGroupControllerTracingConnection::ResizeNodeGroup(
    google::cloud::dataproc::v1::ResizeNodeGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "dataproc_v1::NodeGroupControllerConnection::ResizeNodeGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ResizeNodeGroup(request));
}

StatusOr<google::cloud::dataproc::v1::NodeGroup>
NodeGroupControllerTracingConnection::GetNodeGroup(
    google::cloud::dataproc::v1::GetNodeGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "dataproc_v1::NodeGroupControllerConnection::GetNodeGroup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetNodeGroup(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<dataproc_v1::NodeGroupControllerConnection>
MakeNodeGroupControllerTracingConnection(
    std::shared_ptr<dataproc_v1::NodeGroupControllerConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<NodeGroupControllerTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1_internal
}  // namespace cloud
}  // namespace google
