// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/content.proto

#include "google/cloud/dataplex/v1/internal/content_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace dataplex_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ContentServiceTracingStub::ContentServiceTracingStub(
    std::shared_ptr<ContentServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::dataplex::v1::Content>
ContentServiceTracingStub::CreateContent(
    grpc::ClientContext& context,
    google::cloud::dataplex::v1::CreateContentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.ContentService",
                                     "CreateContent");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateContent(context, request));
}

StatusOr<google::cloud::dataplex::v1::Content>
ContentServiceTracingStub::UpdateContent(
    grpc::ClientContext& context,
    google::cloud::dataplex::v1::UpdateContentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.ContentService",
                                     "UpdateContent");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateContent(context, request));
}

Status ContentServiceTracingStub::DeleteContent(
    grpc::ClientContext& context,
    google::cloud::dataplex::v1::DeleteContentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.ContentService",
                                     "DeleteContent");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteContent(context, request));
}

StatusOr<google::cloud::dataplex::v1::Content>
ContentServiceTracingStub::GetContent(
    grpc::ClientContext& context,
    google::cloud::dataplex::v1::GetContentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.ContentService",
                                     "GetContent");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetContent(context, request));
}

StatusOr<google::iam::v1::Policy> ContentServiceTracingStub::GetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.ContentService",
                                     "GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetIamPolicy(context, request));
}

StatusOr<google::iam::v1::Policy> ContentServiceTracingStub::SetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.ContentService",
                                     "SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->SetIamPolicy(context, request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
ContentServiceTracingStub::TestIamPermissions(
    grpc::ClientContext& context,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.ContentService",
                                     "TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->TestIamPermissions(context, request));
}

StatusOr<google::cloud::dataplex::v1::ListContentResponse>
ContentServiceTracingStub::ListContent(
    grpc::ClientContext& context,
    google::cloud::dataplex::v1::ListContentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dataplex.v1.ContentService",
                                     "ListContent");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListContent(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<ContentServiceStub> MakeContentServiceTracingStub(
    std::shared_ptr<ContentServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<ContentServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1_internal
}  // namespace cloud
}  // namespace google
