// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/datacatalog/v1/policytagmanagerserialization.proto

#include "google/cloud/datacatalog/v1/policy_tag_manager_serialization_connection.h"
#include "google/cloud/datacatalog/v1/internal/policy_tag_manager_serialization_connection_impl.h"
#include "google/cloud/datacatalog/v1/internal/policy_tag_manager_serialization_option_defaults.h"
#include "google/cloud/datacatalog/v1/internal/policy_tag_manager_serialization_stub_factory.h"
#include "google/cloud/datacatalog/v1/internal/policy_tag_manager_serialization_tracing_connection.h"
#include "google/cloud/datacatalog/v1/policy_tag_manager_serialization_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace datacatalog_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PolicyTagManagerSerializationConnection::
    ~PolicyTagManagerSerializationConnection() = default;

StatusOr<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerSerializationConnection::ReplaceTaxonomy(
    google::cloud::datacatalog::v1::ReplaceTaxonomyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::datacatalog::v1::ImportTaxonomiesResponse>
PolicyTagManagerSerializationConnection::ImportTaxonomies(
    google::cloud::datacatalog::v1::ImportTaxonomiesRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::datacatalog::v1::ExportTaxonomiesResponse>
PolicyTagManagerSerializationConnection::ExportTaxonomies(
    google::cloud::datacatalog::v1::ExportTaxonomiesRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<PolicyTagManagerSerializationConnection>
MakePolicyTagManagerSerializationConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 PolicyTagManagerSerializationPolicyOptionList>(
      options, __func__);
  options =
      datacatalog_v1_internal::PolicyTagManagerSerializationDefaultOptions(
          std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub =
      datacatalog_v1_internal::CreateDefaultPolicyTagManagerSerializationStub(
          background->cq(), options);
  return datacatalog_v1_internal::
      MakePolicyTagManagerSerializationTracingConnection(
          std::make_shared<datacatalog_v1_internal::
                               PolicyTagManagerSerializationConnectionImpl>(
              std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datacatalog_v1
}  // namespace cloud
}  // namespace google
