// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/datacatalog/v1/policytagmanager.proto

#include "google/cloud/datacatalog/v1/internal/policy_tag_manager_auth_decorator.h"
#include <google/cloud/datacatalog/v1/policytagmanager.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace datacatalog_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PolicyTagManagerAuth::PolicyTagManagerAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<PolicyTagManagerStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerAuth::CreateTaxonomy(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::CreateTaxonomyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateTaxonomy(context, request);
}

Status PolicyTagManagerAuth::DeleteTaxonomy(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::DeleteTaxonomyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteTaxonomy(context, request);
}

StatusOr<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerAuth::UpdateTaxonomy(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::UpdateTaxonomyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateTaxonomy(context, request);
}

StatusOr<google::cloud::datacatalog::v1::ListTaxonomiesResponse>
PolicyTagManagerAuth::ListTaxonomies(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::ListTaxonomiesRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListTaxonomies(context, request);
}

StatusOr<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerAuth::GetTaxonomy(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::GetTaxonomyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetTaxonomy(context, request);
}

StatusOr<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerAuth::CreatePolicyTag(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::CreatePolicyTagRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreatePolicyTag(context, request);
}

Status PolicyTagManagerAuth::DeletePolicyTag(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::DeletePolicyTagRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeletePolicyTag(context, request);
}

StatusOr<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerAuth::UpdatePolicyTag(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::UpdatePolicyTagRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdatePolicyTag(context, request);
}

StatusOr<google::cloud::datacatalog::v1::ListPolicyTagsResponse>
PolicyTagManagerAuth::ListPolicyTags(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::ListPolicyTagsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListPolicyTags(context, request);
}

StatusOr<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerAuth::GetPolicyTag(
    grpc::ClientContext& context,
    google::cloud::datacatalog::v1::GetPolicyTagRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetPolicyTag(context, request);
}

StatusOr<google::iam::v1::Policy> PolicyTagManagerAuth::GetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetIamPolicy(context, request);
}

StatusOr<google::iam::v1::Policy> PolicyTagManagerAuth::SetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SetIamPolicy(context, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
PolicyTagManagerAuth::TestIamPermissions(
    grpc::ClientContext& context,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->TestIamPermissions(context, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datacatalog_v1_internal
}  // namespace cloud
}  // namespace google
