// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/datacatalog/lineage/v1/lineage.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATACATALOG_LINEAGE_V1_LINEAGE_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATACATALOG_LINEAGE_V1_LINEAGE_CLIENT_H

#include "google/cloud/datacatalog/lineage/v1/lineage_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace datacatalog_lineage_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Lineage is used to track data flows between assets over time. You can
/// create [LineageEvents][google.cloud.datacatalog.lineage.v1.LineageEvent]
/// to record lineage between multiple sources and a single target, for
/// example, when table data is based on data from multiple tables.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
/// [google.cloud.datacatalog.lineage.v1.LineageEvent]:
/// @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L320}
///
class LineageClient {
 public:
  explicit LineageClient(std::shared_ptr<LineageConnection> connection,
                         Options opts = {});
  ~LineageClient();

  ///@{
  /// @name Copy and move support
  LineageClient(LineageClient const&) = default;
  LineageClient& operator=(LineageClient const&) = default;
  LineageClient(LineageClient&&) = default;
  LineageClient& operator=(LineageClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(LineageClient const& a, LineageClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(LineageClient const& a, LineageClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates new lineage events together with their parents: process and run.
  /// Updates the process and run if they already exist.
  /// Mapped from Open Lineage specification:
  /// https://github.com/OpenLineage/OpenLineage/blob/main/spec/OpenLineage.json.
  ///
  /// @param parent  Required. The name of the project and its location that should own the
  ///  process, run, and lineage event.
  /// @param open_lineage  Required. OpenLineage message following OpenLineage format:
  ///  https://github.com/OpenLineage/OpenLineage/blob/main/spec/OpenLineage.json
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEventResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEventRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L425}
  /// [google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEventResponse]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L443}
  ///
  // clang-format on
  StatusOr<google::cloud::datacatalog::lineage::v1::
               ProcessOpenLineageRunEventResponse>
  ProcessOpenLineageRunEvent(std::string const& parent,
                             google::protobuf::Struct const& open_lineage,
                             Options opts = {});

  // clang-format off
  ///
  /// Creates new lineage events together with their parents: process and run.
  /// Updates the process and run if they already exist.
  /// Mapped from Open Lineage specification:
  /// https://github.com/OpenLineage/OpenLineage/blob/main/spec/OpenLineage.json.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEventRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEventResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEventRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L425}
  /// [google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEventResponse]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L443}
  ///
  // clang-format on
  StatusOr<google::cloud::datacatalog::lineage::v1::
               ProcessOpenLineageRunEventResponse>
  ProcessOpenLineageRunEvent(
      google::cloud::datacatalog::lineage::v1::
          ProcessOpenLineageRunEventRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new process.
  ///
  /// @param parent  Required. The name of the project and its location that should own the
  ///  process.
  /// @param process  Required. The process to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datacatalog.lineage.v1.Process])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.CreateProcessRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L467}
  /// [google.cloud.datacatalog.lineage.v1.Process]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L230}
  ///
  // clang-format on
  StatusOr<google::cloud::datacatalog::lineage::v1::Process> CreateProcess(
      std::string const& parent,
      google::cloud::datacatalog::lineage::v1::Process const& process,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new process.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datacatalog.lineage.v1.CreateProcessRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datacatalog.lineage.v1.Process])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.CreateProcessRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L467}
  /// [google.cloud.datacatalog.lineage.v1.Process]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L230}
  ///
  // clang-format on
  StatusOr<google::cloud::datacatalog::lineage::v1::Process> CreateProcess(
      google::cloud::datacatalog::lineage::v1::CreateProcessRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a process.
  ///
  /// @param process  Required. The lineage process to update.
  ///  @n
  ///  The process's `name` field is used to identify the process to update.
  /// @param update_mask  The list of fields to update. Currently not used. The whole message is
  ///  updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datacatalog.lineage.v1.Process])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.Process]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L230}
  /// [google.cloud.datacatalog.lineage.v1.UpdateProcessRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L488}
  ///
  // clang-format on
  StatusOr<google::cloud::datacatalog::lineage::v1::Process> UpdateProcess(
      google::cloud::datacatalog::lineage::v1::Process const& process,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a process.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datacatalog.lineage.v1.UpdateProcessRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datacatalog.lineage.v1.Process])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.Process]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L230}
  /// [google.cloud.datacatalog.lineage.v1.UpdateProcessRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L488}
  ///
  // clang-format on
  StatusOr<google::cloud::datacatalog::lineage::v1::Process> UpdateProcess(
      google::cloud::datacatalog::lineage::v1::UpdateProcessRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the details of the specified process.
  ///
  /// @param name  Required. The name of the process to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datacatalog.lineage.v1.Process])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.GetProcessRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L504}
  /// [google.cloud.datacatalog.lineage.v1.Process]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L230}
  ///
  // clang-format on
  StatusOr<google::cloud::datacatalog::lineage::v1::Process> GetProcess(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the details of the specified process.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datacatalog.lineage.v1.GetProcessRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datacatalog.lineage.v1.Process])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.GetProcessRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L504}
  /// [google.cloud.datacatalog.lineage.v1.Process]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L230}
  ///
  // clang-format on
  StatusOr<google::cloud::datacatalog::lineage::v1::Process> GetProcess(
      google::cloud::datacatalog::lineage::v1::GetProcessRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List processes in the given project and location. List order is descending
  /// by insertion time.
  ///
  /// @param parent  Required. The name of the project and its location that owns this
  ///  collection of processes.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.datacatalog.lineage.v1.Process], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.ListProcessesRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L516}
  /// [google.cloud.datacatalog.lineage.v1.Process]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L230}
  ///
  // clang-format on
  StreamRange<google::cloud::datacatalog::lineage::v1::Process> ListProcesses(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List processes in the given project and location. List order is descending
  /// by insertion time.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datacatalog.lineage.v1.ListProcessesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.datacatalog.lineage.v1.Process], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.ListProcessesRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L516}
  /// [google.cloud.datacatalog.lineage.v1.Process]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L230}
  ///
  // clang-format on
  StreamRange<google::cloud::datacatalog::lineage::v1::Process> ListProcesses(
      google::cloud::datacatalog::lineage::v1::ListProcessesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes the process with the specified name.
  ///
  /// @param name  Required. The name of the process to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datacatalog.lineage.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.DeleteProcessRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L553}
  /// [google.cloud.datacatalog.lineage.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L368}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datacatalog::lineage::v1::OperationMetadata>>
  DeleteProcess(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes the process with the specified name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datacatalog.lineage.v1.DeleteProcessRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datacatalog.lineage.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.DeleteProcessRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L553}
  /// [google.cloud.datacatalog.lineage.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L368}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datacatalog::lineage::v1::OperationMetadata>>
  DeleteProcess(
      google::cloud::datacatalog::lineage::v1::DeleteProcessRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new run.
  ///
  /// @param parent  Required. The name of the process that should own the run.
  /// @param run  Required. The run to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datacatalog.lineage.v1.Run])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.CreateRunRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L569}
  /// [google.cloud.datacatalog.lineage.v1.Run]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L262}
  ///
  // clang-format on
  StatusOr<google::cloud::datacatalog::lineage::v1::Run> CreateRun(
      std::string const& parent,
      google::cloud::datacatalog::lineage::v1::Run const& run,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new run.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datacatalog.lineage.v1.CreateRunRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datacatalog.lineage.v1.Run])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.CreateRunRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L569}
  /// [google.cloud.datacatalog.lineage.v1.Run]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L262}
  ///
  // clang-format on
  StatusOr<google::cloud::datacatalog::lineage::v1::Run> CreateRun(
      google::cloud::datacatalog::lineage::v1::CreateRunRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a run.
  ///
  /// @param run  Required. The lineage run to update.
  ///  @n
  ///  The run's `name` field is used to identify the run to update.
  ///  @n
  ///  Format:
  ///  `projects/{project}/locations/{location}/processes/{process}/runs/{run}`.
  /// @param update_mask  The list of fields to update. Currently not used. The whole message is
  ///  updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datacatalog.lineage.v1.Run])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.Run]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L262}
  /// [google.cloud.datacatalog.lineage.v1.UpdateRunRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L589}
  ///
  // clang-format on
  StatusOr<google::cloud::datacatalog::lineage::v1::Run> UpdateRun(
      google::cloud::datacatalog::lineage::v1::Run const& run,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a run.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datacatalog.lineage.v1.UpdateRunRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datacatalog.lineage.v1.Run])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.Run]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L262}
  /// [google.cloud.datacatalog.lineage.v1.UpdateRunRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L589}
  ///
  // clang-format on
  StatusOr<google::cloud::datacatalog::lineage::v1::Run> UpdateRun(
      google::cloud::datacatalog::lineage::v1::UpdateRunRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the details of the specified run.
  ///
  /// @param name  Required. The name of the run to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datacatalog.lineage.v1.Run])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.GetRunRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L608}
  /// [google.cloud.datacatalog.lineage.v1.Run]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L262}
  ///
  // clang-format on
  StatusOr<google::cloud::datacatalog::lineage::v1::Run> GetRun(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the details of the specified run.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datacatalog.lineage.v1.GetRunRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datacatalog.lineage.v1.Run])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.GetRunRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L608}
  /// [google.cloud.datacatalog.lineage.v1.Run]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L262}
  ///
  // clang-format on
  StatusOr<google::cloud::datacatalog::lineage::v1::Run> GetRun(
      google::cloud::datacatalog::lineage::v1::GetRunRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists runs in the given project and location. List order is descending by
  /// `start_time`.
  ///
  /// @param parent  Required. The name of process that owns this collection of runs.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.datacatalog.lineage.v1.Run], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.ListRunsRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L618}
  /// [google.cloud.datacatalog.lineage.v1.Run]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L262}
  ///
  // clang-format on
  StreamRange<google::cloud::datacatalog::lineage::v1::Run> ListRuns(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists runs in the given project and location. List order is descending by
  /// `start_time`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datacatalog.lineage.v1.ListRunsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.datacatalog.lineage.v1.Run], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.ListRunsRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L618}
  /// [google.cloud.datacatalog.lineage.v1.Run]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L262}
  ///
  // clang-format on
  StreamRange<google::cloud::datacatalog::lineage::v1::Run> ListRuns(
      google::cloud::datacatalog::lineage::v1::ListRunsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes the run with the specified name.
  ///
  /// @param name  Required. The name of the run to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datacatalog.lineage.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.DeleteRunRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L654}
  /// [google.cloud.datacatalog.lineage.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L368}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datacatalog::lineage::v1::OperationMetadata>>
  DeleteRun(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes the run with the specified name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datacatalog.lineage.v1.DeleteRunRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datacatalog.lineage.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.DeleteRunRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L654}
  /// [google.cloud.datacatalog.lineage.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L368}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datacatalog::lineage::v1::OperationMetadata>>
  DeleteRun(
      google::cloud::datacatalog::lineage::v1::DeleteRunRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new lineage event.
  ///
  /// @param parent  Required. The name of the run that should own the lineage event.
  /// @param lineage_event  Required. The lineage event to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datacatalog.lineage.v1.LineageEvent])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.CreateLineageEventRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L668}
  /// [google.cloud.datacatalog.lineage.v1.LineageEvent]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L320}
  ///
  // clang-format on
  StatusOr<google::cloud::datacatalog::lineage::v1::LineageEvent>
  CreateLineageEvent(
      std::string const& parent,
      google::cloud::datacatalog::lineage::v1::LineageEvent const&
          lineage_event,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new lineage event.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datacatalog.lineage.v1.CreateLineageEventRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datacatalog.lineage.v1.LineageEvent])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.CreateLineageEventRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L668}
  /// [google.cloud.datacatalog.lineage.v1.LineageEvent]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L320}
  ///
  // clang-format on
  StatusOr<google::cloud::datacatalog::lineage::v1::LineageEvent>
  CreateLineageEvent(
      google::cloud::datacatalog::lineage::v1::CreateLineageEventRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a specified lineage event.
  ///
  /// @param name  Required. The name of the lineage event to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datacatalog.lineage.v1.LineageEvent])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.GetLineageEventRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L688}
  /// [google.cloud.datacatalog.lineage.v1.LineageEvent]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L320}
  ///
  // clang-format on
  StatusOr<google::cloud::datacatalog::lineage::v1::LineageEvent>
  GetLineageEvent(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a specified lineage event.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datacatalog.lineage.v1.GetLineageEventRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datacatalog.lineage.v1.LineageEvent])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.GetLineageEventRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L688}
  /// [google.cloud.datacatalog.lineage.v1.LineageEvent]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L320}
  ///
  // clang-format on
  StatusOr<google::cloud::datacatalog::lineage::v1::LineageEvent>
  GetLineageEvent(
      google::cloud::datacatalog::lineage::v1::GetLineageEventRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists lineage events in the given project and location. The list order is
  /// not defined.
  ///
  /// @param parent  Required. The name of the run that owns the collection of lineage events to
  ///  get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.datacatalog.lineage.v1.LineageEvent], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.LineageEvent]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L320}
  /// [google.cloud.datacatalog.lineage.v1.ListLineageEventsRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L700}
  ///
  // clang-format on
  StreamRange<google::cloud::datacatalog::lineage::v1::LineageEvent>
  ListLineageEvents(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists lineage events in the given project and location. The list order is
  /// not defined.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datacatalog.lineage.v1.ListLineageEventsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.datacatalog.lineage.v1.LineageEvent], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.LineageEvent]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L320}
  /// [google.cloud.datacatalog.lineage.v1.ListLineageEventsRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L700}
  ///
  // clang-format on
  StreamRange<google::cloud::datacatalog::lineage::v1::LineageEvent>
  ListLineageEvents(
      google::cloud::datacatalog::lineage::v1::ListLineageEventsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes the lineage event with the specified name.
  ///
  /// @param name  Required. The name of the lineage event to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.DeleteLineageEventRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L738}
  ///
  // clang-format on
  Status DeleteLineageEvent(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes the lineage event with the specified name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datacatalog.lineage.v1.DeleteLineageEventRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.DeleteLineageEventRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L738}
  ///
  // clang-format on
  Status DeleteLineageEvent(
      google::cloud::datacatalog::lineage::v1::DeleteLineageEventRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieve a list of links connected to a specific asset.
  /// Links represent the data flow between **source** (upstream)
  /// and **target** (downstream) assets in transformation pipelines.
  /// Links are stored in the same project as the Lineage Events that create
  /// them.
  ///
  /// You can retrieve links in every project where you have the
  /// `datalineage.events.get` permission. The project provided in the URL
  /// is used for Billing and Quota.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datacatalog.lineage.v1.SearchLinksRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.datacatalog.lineage.v1.Link], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.Link]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L807}
  /// [google.cloud.datacatalog.lineage.v1.SearchLinksRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L754}
  ///
  // clang-format on
  StreamRange<google::cloud::datacatalog::lineage::v1::Link> SearchLinks(
      google::cloud::datacatalog::lineage::v1::SearchLinksRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieve information about LineageProcesses associated with specific
  /// links. LineageProcesses are transformation pipelines that result in data
  /// flowing from **source** to **target** assets. Links between assets
  /// represent this operation.
  ///
  /// If you have specific link names, you can use this method to
  /// verify which LineageProcesses contribute to creating those links.
  /// See the
  /// [SearchLinks][google.cloud.datacatalog.lineage.v1.Lineage.SearchLinks]
  /// method for more information on how to retrieve link name.
  ///
  /// You can retrieve the LineageProcess information in every project where you
  /// have the `datalineage.events.get` permission. The project provided in the
  /// URL is used for Billing and Quota.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datacatalog.lineage.v1.BatchSearchLinkProcessesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.datacatalog.lineage.v1.ProcessLinks], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datacatalog.lineage.v1.BatchSearchLinkProcessesRequest]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L830}
  /// [google.cloud.datacatalog.lineage.v1.Lineage.SearchLinks]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L199}
  /// [google.cloud.datacatalog.lineage.v1.ProcessLinks]: @googleapis_reference_link{google/cloud/datacatalog/lineage/v1/lineage.proto#L873}
  ///
  // clang-format on
  StreamRange<google::cloud::datacatalog::lineage::v1::ProcessLinks>
  BatchSearchLinkProcesses(
      google::cloud::datacatalog::lineage::v1::BatchSearchLinkProcessesRequest
          request,
      Options opts = {});

 private:
  std::shared_ptr<LineageConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datacatalog_lineage_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATACATALOG_LINEAGE_V1_LINEAGE_CLIENT_H
