// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/document_schema_service.proto

#include "google/cloud/contentwarehouse/v1/internal/document_schema_auth_decorator.h"
#include <google/cloud/contentwarehouse/v1/document_schema_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace contentwarehouse_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DocumentSchemaServiceAuth::DocumentSchemaServiceAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<DocumentSchemaServiceStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::contentwarehouse::v1::DocumentSchema>
DocumentSchemaServiceAuth::CreateDocumentSchema(
    grpc::ClientContext& context,
    google::cloud::contentwarehouse::v1::CreateDocumentSchemaRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateDocumentSchema(context, request);
}

StatusOr<google::cloud::contentwarehouse::v1::DocumentSchema>
DocumentSchemaServiceAuth::UpdateDocumentSchema(
    grpc::ClientContext& context,
    google::cloud::contentwarehouse::v1::UpdateDocumentSchemaRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateDocumentSchema(context, request);
}

StatusOr<google::cloud::contentwarehouse::v1::DocumentSchema>
DocumentSchemaServiceAuth::GetDocumentSchema(
    grpc::ClientContext& context,
    google::cloud::contentwarehouse::v1::GetDocumentSchemaRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetDocumentSchema(context, request);
}

Status DocumentSchemaServiceAuth::DeleteDocumentSchema(
    grpc::ClientContext& context,
    google::cloud::contentwarehouse::v1::DeleteDocumentSchemaRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteDocumentSchema(context, request);
}

StatusOr<google::cloud::contentwarehouse::v1::ListDocumentSchemasResponse>
DocumentSchemaServiceAuth::ListDocumentSchemas(
    grpc::ClientContext& context,
    google::cloud::contentwarehouse::v1::ListDocumentSchemasRequest const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListDocumentSchemas(context, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1_internal
}  // namespace cloud
}  // namespace google
