// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/target_instances/v1/target_instances.proto

#include "google/cloud/compute/target_instances/v1/target_instances_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_target_instances_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

TargetInstancesConnectionIdempotencyPolicy::
    ~TargetInstancesConnectionIdempotencyPolicy() = default;

std::unique_ptr<TargetInstancesConnectionIdempotencyPolicy>
TargetInstancesConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<TargetInstancesConnectionIdempotencyPolicy>(*this);
}

Idempotency
TargetInstancesConnectionIdempotencyPolicy::AggregatedListTargetInstances(
    google::cloud::cpp::compute::target_instances::v1::
        AggregatedListTargetInstancesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency TargetInstancesConnectionIdempotencyPolicy::DeleteTargetInstance(
    google::cloud::cpp::compute::target_instances::v1::
        DeleteTargetInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TargetInstancesConnectionIdempotencyPolicy::GetTargetInstance(
    google::cloud::cpp::compute::target_instances::v1::
        GetTargetInstanceRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TargetInstancesConnectionIdempotencyPolicy::InsertTargetInstance(
    google::cloud::cpp::compute::target_instances::v1::
        InsertTargetInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TargetInstancesConnectionIdempotencyPolicy::ListTargetInstances(
    google::cloud::cpp::compute::target_instances::v1::
        ListTargetInstancesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency TargetInstancesConnectionIdempotencyPolicy::SetSecurityPolicy(
    google::cloud::cpp::compute::target_instances::v1::
        SetSecurityPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<TargetInstancesConnectionIdempotencyPolicy>
MakeDefaultTargetInstancesConnectionIdempotencyPolicy() {
  return std::make_unique<TargetInstancesConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_target_instances_v1
}  // namespace cloud
}  // namespace google
