// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/instance_groups/v1/instance_groups.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_INSTANCE_GROUPS_V1_INSTANCE_GROUPS_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_INSTANCE_GROUPS_V1_INSTANCE_GROUPS_CONNECTION_H

#include "google/cloud/compute/instance_groups/v1/instance_groups_connection_idempotency_policy.h"
#include "google/cloud/compute/instance_groups/v1/internal/instance_groups_retry_traits.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/compute/instance_groups/v1/instance_groups.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace compute_instance_groups_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `InstanceGroupsConnection`.
class InstanceGroupsRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<InstanceGroupsRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `InstanceGroupsConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class InstanceGroupsLimitedErrorCountRetryPolicy
    : public InstanceGroupsRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit InstanceGroupsLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  InstanceGroupsLimitedErrorCountRetryPolicy(
      InstanceGroupsLimitedErrorCountRetryPolicy&& rhs) noexcept
      : InstanceGroupsLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  InstanceGroupsLimitedErrorCountRetryPolicy(
      InstanceGroupsLimitedErrorCountRetryPolicy const& rhs) noexcept
      : InstanceGroupsLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<InstanceGroupsRetryPolicy> clone() const override {
    return std::make_unique<InstanceGroupsLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = InstanceGroupsRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      compute_instance_groups_v1_internal::InstanceGroupsRetryTraits>
      impl_;
};

/**
 * A retry policy for `InstanceGroupsConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class InstanceGroupsLimitedTimeRetryPolicy : public InstanceGroupsRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit InstanceGroupsLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  InstanceGroupsLimitedTimeRetryPolicy(
      InstanceGroupsLimitedTimeRetryPolicy&& rhs) noexcept
      : InstanceGroupsLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  InstanceGroupsLimitedTimeRetryPolicy(
      InstanceGroupsLimitedTimeRetryPolicy const& rhs) noexcept
      : InstanceGroupsLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<InstanceGroupsRetryPolicy> clone() const override {
    return std::make_unique<InstanceGroupsLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = InstanceGroupsRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      compute_instance_groups_v1_internal::InstanceGroupsRetryTraits>
      impl_;
};

/**
 * The `InstanceGroupsConnection` object for `InstanceGroupsClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `InstanceGroupsClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `InstanceGroupsClient`.
 *
 * To create a concrete instance, see `MakeInstanceGroupsConnection()`.
 *
 * For mocking, see
 * `compute_instance_groups_v1_mocks::MockInstanceGroupsConnection`.
 */
class InstanceGroupsConnection {
 public:
  virtual ~InstanceGroupsConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  AddInstances(google::cloud::cpp::compute::instance_groups::v1::
                   AddInstancesRequest const& request);

  virtual StreamRange<std::pair<
      std::string, google::cloud::cpp::compute::v1::InstanceGroupsScopedList>>
  AggregatedListInstanceGroups(
      google::cloud::cpp::compute::instance_groups::v1::
          AggregatedListInstanceGroupsRequest request);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteInstanceGroup(google::cloud::cpp::compute::instance_groups::v1::
                          DeleteInstanceGroupRequest const& request);

  virtual StatusOr<google::cloud::cpp::compute::v1::InstanceGroup>
  GetInstanceGroup(google::cloud::cpp::compute::instance_groups::v1::
                       GetInstanceGroupRequest const& request);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertInstanceGroup(google::cloud::cpp::compute::instance_groups::v1::
                          InsertInstanceGroupRequest const& request);

  virtual StreamRange<google::cloud::cpp::compute::v1::InstanceGroup>
  ListInstanceGroups(google::cloud::cpp::compute::instance_groups::v1::
                         ListInstanceGroupsRequest request);

  virtual StreamRange<google::cloud::cpp::compute::v1::InstanceWithNamedPorts>
  ListInstances(
      google::cloud::cpp::compute::instance_groups::v1::ListInstancesRequest
          request);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  RemoveInstances(google::cloud::cpp::compute::instance_groups::v1::
                      RemoveInstancesRequest const& request);

  virtual future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  SetNamedPorts(google::cloud::cpp::compute::instance_groups::v1::
                    SetNamedPortsRequest const& request);
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_instance_groups_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_INSTANCE_GROUPS_V1_INSTANCE_GROUPS_CONNECTION_H
