// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/global_operations/v1/global_operations.proto

#include "google/cloud/compute/global_operations/v1/global_operations_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_global_operations_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GlobalOperationsClient::GlobalOperationsClient(
    std::shared_ptr<GlobalOperationsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
GlobalOperationsClient::~GlobalOperationsClient() = default;

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::OperationsScopedList>>
GlobalOperationsClient::AggregatedListGlobalOperations(
    std::string const& project, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_operations::v1::
      AggregatedListGlobalOperationsRequest request;
  request.set_project(project);
  return connection_->AggregatedListGlobalOperations(request);
}

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::OperationsScopedList>>
GlobalOperationsClient::AggregatedListGlobalOperations(
    google::cloud::cpp::compute::global_operations::v1::
        AggregatedListGlobalOperationsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AggregatedListGlobalOperations(std::move(request));
}

Status GlobalOperationsClient::DeleteOperation(std::string const& project,
                                               std::string const& operation,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_operations::v1::DeleteOperationRequest
      request;
  request.set_project(project);
  request.set_operation(operation);
  return connection_->DeleteOperation(request);
}

Status GlobalOperationsClient::DeleteOperation(
    google::cloud::cpp::compute::global_operations::v1::
        DeleteOperationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteOperation(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
GlobalOperationsClient::GetOperation(std::string const& project,
                                     std::string const& operation,
                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_operations::v1::GetOperationRequest
      request;
  request.set_project(project);
  request.set_operation(operation);
  return connection_->GetOperation(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
GlobalOperationsClient::GetOperation(
    google::cloud::cpp::compute::global_operations::v1::
        GetOperationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

StreamRange<google::cloud::cpp::compute::v1::Operation>
GlobalOperationsClient::ListGlobalOperations(std::string const& project,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_operations::v1::
      ListGlobalOperationsRequest request;
  request.set_project(project);
  return connection_->ListGlobalOperations(request);
}

StreamRange<google::cloud::cpp::compute::v1::Operation>
GlobalOperationsClient::ListGlobalOperations(
    google::cloud::cpp::compute::global_operations::v1::
        ListGlobalOperationsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListGlobalOperations(std::move(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
GlobalOperationsClient::Wait(std::string const& project,
                             std::string const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_operations::v1::WaitRequest request;
  request.set_project(project);
  request.set_operation(operation);
  return connection_->Wait(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
GlobalOperationsClient::Wait(
    google::cloud::cpp::compute::global_operations::v1::WaitRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Wait(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_global_operations_v1
}  // namespace cloud
}  // namespace google
