// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/migration/v2/migration_service.proto

#include "google/cloud/bigquery/migration/v2/internal/migration_metadata_decorator.h"
#include "google/cloud/common_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/bigquery/migration/v2/migration_service.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquery_migration_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MigrationServiceMetadata::MigrationServiceMetadata(
    std::shared_ptr<MigrationServiceStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::bigquery::migration::v2::MigrationWorkflow>
MigrationServiceMetadata::CreateMigrationWorkflow(
    grpc::ClientContext& context,
    google::cloud::bigquery::migration::v2::
        CreateMigrationWorkflowRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateMigrationWorkflow(context, request);
}

StatusOr<google::cloud::bigquery::migration::v2::MigrationWorkflow>
MigrationServiceMetadata::GetMigrationWorkflow(
    grpc::ClientContext& context,
    google::cloud::bigquery::migration::v2::GetMigrationWorkflowRequest const&
        request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetMigrationWorkflow(context, request);
}

StatusOr<google::cloud::bigquery::migration::v2::ListMigrationWorkflowsResponse>
MigrationServiceMetadata::ListMigrationWorkflows(
    grpc::ClientContext& context,
    google::cloud::bigquery::migration::v2::ListMigrationWorkflowsRequest const&
        request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListMigrationWorkflows(context, request);
}

Status MigrationServiceMetadata::DeleteMigrationWorkflow(
    grpc::ClientContext& context,
    google::cloud::bigquery::migration::v2::
        DeleteMigrationWorkflowRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteMigrationWorkflow(context, request);
}

Status MigrationServiceMetadata::StartMigrationWorkflow(
    grpc::ClientContext& context,
    google::cloud::bigquery::migration::v2::StartMigrationWorkflowRequest const&
        request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->StartMigrationWorkflow(context, request);
}

StatusOr<google::cloud::bigquery::migration::v2::MigrationSubtask>
MigrationServiceMetadata::GetMigrationSubtask(
    grpc::ClientContext& context,
    google::cloud::bigquery::migration::v2::GetMigrationSubtaskRequest const&
        request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetMigrationSubtask(context, request);
}

StatusOr<google::cloud::bigquery::migration::v2::ListMigrationSubtasksResponse>
MigrationServiceMetadata::ListMigrationSubtasks(
    grpc::ClientContext& context,
    google::cloud::bigquery::migration::v2::ListMigrationSubtasksRequest const&
        request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListMigrationSubtasks(context, request);
}

void MigrationServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                           Options const& options,
                                           std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void MigrationServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                           Options const& options) {
  for (auto const& kv : fixed_metadata_) {
    context.AddMetadata(kv.first, kv.second);
  }
  context.AddMetadata("x-goog-api-client", api_client_header_);
  if (options.has<UserProjectOption>()) {
    context.AddMetadata("x-goog-user-project",
                        options.get<UserProjectOption>());
  }
  auto const& authority = options.get<AuthorityOption>();
  if (!authority.empty()) context.set_authority(authority);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_migration_v2_internal
}  // namespace cloud
}  // namespace google
