// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/migration/v2/migration_service.proto

#include "google/cloud/bigquery/migration/v2/internal/migration_connection_impl.h"
#include "google/cloud/bigquery/migration/v2/internal/migration_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_migration_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<bigquery_migration_v2::MigrationServiceRetryPolicy>
retry_policy(Options const& options) {
  return options
      .get<bigquery_migration_v2::MigrationServiceRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<bigquery_migration_v2::MigrationServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<
    bigquery_migration_v2::MigrationServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<bigquery_migration_v2::
               MigrationServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

MigrationServiceConnectionImpl::MigrationServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<bigquery_migration_v2_internal::MigrationServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      MigrationServiceConnection::options())) {}

StatusOr<google::cloud::bigquery::migration::v2::MigrationWorkflow>
MigrationServiceConnectionImpl::CreateMigrationWorkflow(
    google::cloud::bigquery::migration::v2::
        CreateMigrationWorkflowRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateMigrationWorkflow(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::migration::v2::
                 CreateMigrationWorkflowRequest const& request) {
        return stub_->CreateMigrationWorkflow(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::bigquery::migration::v2::MigrationWorkflow>
MigrationServiceConnectionImpl::GetMigrationWorkflow(
    google::cloud::bigquery::migration::v2::GetMigrationWorkflowRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetMigrationWorkflow(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::migration::v2::
                 GetMigrationWorkflowRequest const& request) {
        return stub_->GetMigrationWorkflow(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::bigquery::migration::v2::MigrationWorkflow>
MigrationServiceConnectionImpl::ListMigrationWorkflows(
    google::cloud::bigquery::migration::v2::ListMigrationWorkflowsRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListMigrationWorkflows(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::bigquery::migration::v2::MigrationWorkflow>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<bigquery_migration_v2::MigrationServiceRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::bigquery::migration::v2::
              ListMigrationWorkflowsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::bigquery::migration::v2::
                       ListMigrationWorkflowsRequest const& request) {
              return stub->ListMigrationWorkflows(context, request);
            },
            r, function_name);
      },
      [](google::cloud::bigquery::migration::v2::ListMigrationWorkflowsResponse
             r) {
        std::vector<google::cloud::bigquery::migration::v2::MigrationWorkflow>
            result(r.migration_workflows().size());
        auto& messages = *r.mutable_migration_workflows();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

Status MigrationServiceConnectionImpl::DeleteMigrationWorkflow(
    google::cloud::bigquery::migration::v2::
        DeleteMigrationWorkflowRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteMigrationWorkflow(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::migration::v2::
                 DeleteMigrationWorkflowRequest const& request) {
        return stub_->DeleteMigrationWorkflow(context, request);
      },
      request, __func__);
}

Status MigrationServiceConnectionImpl::StartMigrationWorkflow(
    google::cloud::bigquery::migration::v2::StartMigrationWorkflowRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->StartMigrationWorkflow(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::migration::v2::
                 StartMigrationWorkflowRequest const& request) {
        return stub_->StartMigrationWorkflow(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::bigquery::migration::v2::MigrationSubtask>
MigrationServiceConnectionImpl::GetMigrationSubtask(
    google::cloud::bigquery::migration::v2::GetMigrationSubtaskRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetMigrationSubtask(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::migration::v2::
                 GetMigrationSubtaskRequest const& request) {
        return stub_->GetMigrationSubtask(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::bigquery::migration::v2::MigrationSubtask>
MigrationServiceConnectionImpl::ListMigrationSubtasks(
    google::cloud::bigquery::migration::v2::ListMigrationSubtasksRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListMigrationSubtasks(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::bigquery::migration::v2::MigrationSubtask>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<bigquery_migration_v2::MigrationServiceRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::bigquery::migration::v2::
              ListMigrationSubtasksRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::bigquery::migration::v2::
                       ListMigrationSubtasksRequest const& request) {
              return stub->ListMigrationSubtasks(context, request);
            },
            r, function_name);
      },
      [](google::cloud::bigquery::migration::v2::ListMigrationSubtasksResponse
             r) {
        std::vector<google::cloud::bigquery::migration::v2::MigrationSubtask>
            result(r.migration_subtasks().size());
        auto& messages = *r.mutable_migration_subtasks();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_migration_v2_internal
}  // namespace cloud
}  // namespace google
