// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/appengine/v1/appengine.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_V1_INTERNAL_DOMAIN_MAPPINGS_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_V1_INTERNAL_DOMAIN_MAPPINGS_CONNECTION_IMPL_H

#include "google/cloud/appengine/v1/domain_mappings_connection.h"
#include "google/cloud/appengine/v1/domain_mappings_connection_idempotency_policy.h"
#include "google/cloud/appengine/v1/domain_mappings_options.h"
#include "google/cloud/appengine/v1/internal/domain_mappings_retry_traits.h"
#include "google/cloud/appengine/v1/internal/domain_mappings_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace appengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DomainMappingsConnectionImpl
    : public appengine_v1::DomainMappingsConnection {
 public:
  ~DomainMappingsConnectionImpl() override = default;

  DomainMappingsConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<appengine_v1_internal::DomainMappingsStub> stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<google::appengine::v1::DomainMapping> ListDomainMappings(
      google::appengine::v1::ListDomainMappingsRequest request) override;

  StatusOr<google::appengine::v1::DomainMapping> GetDomainMapping(
      google::appengine::v1::GetDomainMappingRequest const& request) override;

  future<StatusOr<google::appengine::v1::DomainMapping>> CreateDomainMapping(
      google::appengine::v1::CreateDomainMappingRequest const& request)
      override;

  future<StatusOr<google::appengine::v1::DomainMapping>> UpdateDomainMapping(
      google::appengine::v1::UpdateDomainMappingRequest const& request)
      override;

  future<StatusOr<google::appengine::v1::OperationMetadataV1>>
  DeleteDomainMapping(google::appengine::v1::DeleteDomainMappingRequest const&
                          request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<appengine_v1_internal::DomainMappingsStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace appengine_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_V1_INTERNAL_DOMAIN_MAPPINGS_CONNECTION_IMPL_H
