// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/model_service.proto

#include "google/cloud/aiplatform/v1/model_connection.h"
#include "google/cloud/aiplatform/v1/internal/model_connection_impl.h"
#include "google/cloud/aiplatform/v1/internal/model_option_defaults.h"
#include "google/cloud/aiplatform/v1/internal/model_stub_factory.h"
#include "google/cloud/aiplatform/v1/internal/model_tracing_connection.h"
#include "google/cloud/aiplatform/v1/model_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ModelServiceConnection::~ModelServiceConnection() = default;

future<StatusOr<google::cloud::aiplatform::v1::UploadModelResponse>>
ModelServiceConnection::UploadModel(
    google::cloud::aiplatform::v1::UploadModelRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::UploadModelResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::aiplatform::v1::Model> ModelServiceConnection::GetModel(
    google::cloud::aiplatform::v1::GetModelRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::Model>
ModelServiceConnection::ListModels(
    google::cloud::aiplatform::v1::
        ListModelsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::Model>>();
}

StreamRange<google::cloud::aiplatform::v1::Model>
ModelServiceConnection::ListModelVersions(
    google::cloud::aiplatform::v1::
        ListModelVersionsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::Model>>();
}

StatusOr<google::cloud::aiplatform::v1::Model>
ModelServiceConnection::UpdateModel(
    google::cloud::aiplatform::v1::UpdateModelRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<
    StatusOr<google::cloud::aiplatform::v1::UpdateExplanationDatasetResponse>>
ModelServiceConnection::UpdateExplanationDataset(
    google::cloud::aiplatform::v1::UpdateExplanationDatasetRequest const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::cloud::aiplatform::v1::UpdateExplanationDatasetResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
ModelServiceConnection::DeleteModel(
    google::cloud::aiplatform::v1::DeleteModelRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
ModelServiceConnection::DeleteModelVersion(
    google::cloud::aiplatform::v1::DeleteModelVersionRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::aiplatform::v1::Model>
ModelServiceConnection::MergeVersionAliases(
    google::cloud::aiplatform::v1::MergeVersionAliasesRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::aiplatform::v1::ExportModelResponse>>
ModelServiceConnection::ExportModel(
    google::cloud::aiplatform::v1::ExportModelRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::ExportModelResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::CopyModelResponse>>
ModelServiceConnection::CopyModel(
    google::cloud::aiplatform::v1::CopyModelRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::CopyModelResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::aiplatform::v1::ModelEvaluation>
ModelServiceConnection::ImportModelEvaluation(
    google::cloud::aiplatform::v1::ImportModelEvaluationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<
    google::cloud::aiplatform::v1::BatchImportModelEvaluationSlicesResponse>
ModelServiceConnection::BatchImportModelEvaluationSlices(
    google::cloud::aiplatform::v1::
        BatchImportModelEvaluationSlicesRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::BatchImportEvaluatedAnnotationsResponse>
ModelServiceConnection::BatchImportEvaluatedAnnotations(
    google::cloud::aiplatform::v1::
        BatchImportEvaluatedAnnotationsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::ModelEvaluation>
ModelServiceConnection::GetModelEvaluation(
    google::cloud::aiplatform::v1::GetModelEvaluationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::ModelEvaluation>
ModelServiceConnection::ListModelEvaluations(
    google::cloud::aiplatform::v1::
        ListModelEvaluationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::ModelEvaluation>>();
}

StatusOr<google::cloud::aiplatform::v1::ModelEvaluationSlice>
ModelServiceConnection::GetModelEvaluationSlice(
    google::cloud::aiplatform::v1::GetModelEvaluationSliceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::ModelEvaluationSlice>
ModelServiceConnection::ListModelEvaluationSlices(
    google::cloud::aiplatform::v1::
        ListModelEvaluationSlicesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::ModelEvaluationSlice>>();
}

std::shared_ptr<ModelServiceConnection> MakeModelServiceConnection(
    std::string const& location, Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ModelServicePolicyOptionList>(options,
                                                               __func__);
  options = aiplatform_v1_internal::ModelServiceDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = aiplatform_v1_internal::CreateDefaultModelServiceStub(
      background->cq(), options);
  return aiplatform_v1_internal::MakeModelServiceTracingConnection(
      std::make_shared<aiplatform_v1_internal::ModelServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
