/*
 *  hap -- a mail notification program
 * 
 *  copyright 1995 by Eric Fischer, etaoin@uchicago.edu
 * 
 *  copies of hap may be redistributed under the terms of the
 *  GNU public license, copies of which are available from
 *  the Free Software Foundation, 59 Temple Place, Boston, MA
 *  02111 USA.
 *
 */

#include "hap.h"

/**************************************************************************
 
   hacked for mh version of
   MAILBOX -> NOTIFICATION STUFF

**************************************************************************/

/* returns the message in folder/file, assuming it's an mh-style
   one-message-per-file thing.
*/

char *
readmh (folder, file)
	char *folder;
	char *file;
{
	hlist headerlist;
	static char *msg = 0;
	char *thequote = 0;
	static char *fullname = 0;

	FILE *f;
	long here = 0;
	int quotesleft = 0;

	char *s;

	if (msg) free (msg), msg = 0;
	if (fullname) free (fullname), fullname = 0;

	inithlist (&headerlist);
	headerlist.msgnumstr = strdupe (file);

	fullname = strdupe (folder);
	addstr (&fullname, "/");
	addstr (&fullname, file);

	f = fopen (fullname, "r");
	if (f == 0) {
		msg = addtostr (msg, "   * Unable to open ");
		msg = addtostr (msg, fullname);
		msg = addtostr (msg, ": ");
		msg = addtostr (msg, strerror (errno));
		msg = addtostr (msg, "\n");
		return msg;
	}

	quotesleft = wantquote;

	readheaders (&headerlist, f);
	headerlist.startpoint = 0;

	while (here = ftell (f), s = fgetl (f)) {
		if (quotesleft && nottobeignored (s)) {
			addstr (&thequote, "     ");
			addstr (&thequote, s);
			quotesleft--;
		}
	}

	fclose (f);

	headerlist.endpoint = here;

	dumpheaders (&msg, &headerlist);
	dumpquote (&msg, &thequote);

	return msg;
}
