/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.impl;

import java.nio.ByteOrder;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.IDisconnectCallback;
import org.freedesktop.dbus.connections.config.ReceivingServiceConfig;
import org.freedesktop.dbus.connections.config.ReceivingServiceConfigBuilder;
import org.freedesktop.dbus.connections.config.TransportConfig;
import org.freedesktop.dbus.connections.config.TransportConfigBuilder;
import org.freedesktop.dbus.connections.impl.ConnectionConfig;
import org.freedesktop.dbus.exceptions.DBusException;

public abstract class BaseConnectionBuilder<R extends BaseConnectionBuilder<R, C>, C extends AbstractConnection> {
    private final Class<R> returnType;
    private final ReceivingServiceConfigBuilder<R> rsConfigBuilder;
    private final TransportConfigBuilder<?, R> transportConfigBuilder;
    private final ConnectionConfig connectionConfig;

    protected BaseConnectionBuilder(Class<R> _returnType, BusAddress _address) {
        this.returnType = _returnType;
        this.connectionConfig = new ConnectionConfig();
        this.rsConfigBuilder = new ReceivingServiceConfigBuilder<BaseConnectionBuilder>(this::self);
        this.transportConfigBuilder = new TransportConfigBuilder(this::self);
        this.transportConfigBuilder.withBusAddress(_address);
    }

    R self() {
        return (R)((BaseConnectionBuilder)this.returnType.cast(this));
    }

    protected ReceivingServiceConfig buildThreadConfig() {
        return this.rsConfigBuilder.build();
    }

    protected TransportConfig buildTransportConfig() {
        return this.transportConfigBuilder.build();
    }

    protected ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public ReceivingServiceConfigBuilder<R> receivingThreadConfig() {
        return this.rsConfigBuilder;
    }

    public TransportConfigBuilder<?, R> transportConfig() {
        return this.transportConfigBuilder;
    }

    @Deprecated(forRemoval=true, since="5.1.0 - 2024-07-12")
    public R withWeakReferences(boolean _weakRef) {
        return this.withExportWeakReferences(_weakRef);
    }

    public R withExportWeakReferences(boolean _weakRef) {
        this.connectionConfig.setExportWeakReferences(_weakRef);
        return this.self();
    }

    public R withImportWeakReferences(boolean _weakRef) {
        this.connectionConfig.setImportWeakReferences(_weakRef);
        return this.self();
    }

    public R withDisconnectCallback(IDisconnectCallback _disconnectCallback) {
        this.connectionConfig.setDisconnectCallback(_disconnectCallback);
        return this.self();
    }

    public abstract C build() throws DBusException;

    public static byte getSystemEndianness() {
        return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? (byte)66 : 108;
    }
}

