// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// LogForwardBase Log Forward
//
// # HAProxy log forward configuration
//
// swagger:model log_forward_base
type LogForwardBase struct {

	// backlog
	Backlog *int64 `json:"backlog,omitempty"`

	// maxconn
	Maxconn *int64 `json:"maxconn,omitempty"`

	// name
	// Required: true
	// Pattern: ^[A-Za-z0-9-_.:]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_.:]+$`
	Name string `json:"name"`

	// timeout client
	// Maximum: 2.147483647e+09
	// Minimum: 0
	// +kubebuilder:validation:Maximum=2.147483647e+09
	// +kubebuilder:validation:Minimum=0
	TimeoutClient *int64 `json:"timeout_client,omitempty"`
}

// Validate validates this log forward base
func (m *LogForwardBase) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimeoutClient(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogForwardBase) validateName(formats strfmt.Registry) error {

	if err := validate.RequiredString("name", "body", m.Name); err != nil {
		return err
	}

	if err := validate.Pattern("name", "body", m.Name, `^[A-Za-z0-9-_.:]+$`); err != nil {
		return err
	}

	return nil
}

func (m *LogForwardBase) validateTimeoutClient(formats strfmt.Registry) error {
	if swag.IsZero(m.TimeoutClient) { // not required
		return nil
	}

	if err := validate.MinimumInt("timeout_client", "body", *m.TimeoutClient, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("timeout_client", "body", *m.TimeoutClient, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this log forward base based on context it is used
func (m *LogForwardBase) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *LogForwardBase) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LogForwardBase) UnmarshalBinary(b []byte) error {
	var res LogForwardBase
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
