// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HTTPRequestRule HTTP Request Rule
//
// HAProxy HTTP request rule configuration (corresponds to http-request directives)
// Example: {"cond":"unless","cond_test":"{ src 192.168.0.0/16 }","hdr_format":"%T","hdr_name":"X-Haproxy-Current-Date","index":0,"type":"add-header"}
//
// swagger:model http_request_rule
type HTTPRequestRule struct {

	// return headers
	ReturnHeaders []*ReturnHeader `json:"return_hdrs,omitempty"`

	// acl file
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	ACLFile string `json:"acl_file,omitempty"`

	// acl keyfmt
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	ACLKeyfmt string `json:"acl_keyfmt,omitempty"`

	// auth realm
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	AuthRealm string `json:"auth_realm,omitempty"`

	// bandwidth limit limit
	BandwidthLimitLimit string `json:"bandwidth_limit_limit,omitempty"`

	// bandwidth limit name
	BandwidthLimitName string `json:"bandwidth_limit_name,omitempty"`

	// bandwidth limit period
	BandwidthLimitPeriod string `json:"bandwidth_limit_period,omitempty"`

	// cache name
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	CacheName string `json:"cache_name,omitempty"`

	// capture id
	CaptureID *int64 `json:"capture_id,omitempty"`

	// capture len
	CaptureLen int64 `json:"capture_len,omitempty"`

	// capture sample
	// Pattern: ^(?:[A-Za-z]+\("([A-Za-z\s]+)"\)|[A-Za-z]+)
	// +kubebuilder:validation:Pattern=`^(?:[A-Za-z]+\("([A-Za-z\s]+)"\)|[A-Za-z]+)`
	CaptureSample string `json:"capture_sample,omitempty"`

	// cond
	// Enum: ["if","unless"]
	// +kubebuilder:validation:Enum=if;unless;
	Cond string `json:"cond,omitempty"`

	// cond test
	CondTest string `json:"cond_test,omitempty"`

	// deny status
	// Maximum: 599
	// Minimum: 200
	// +kubebuilder:validation:Maximum=599
	// +kubebuilder:validation:Minimum=200
	DenyStatus *int64 `json:"deny_status,omitempty"`

	// expr
	Expr string `json:"expr,omitempty"`

	// hdr format
	HdrFormat string `json:"hdr_format,omitempty"`

	// hdr match
	HdrMatch string `json:"hdr_match,omitempty"`

	// hdr method
	HdrMethod string `json:"hdr_method,omitempty"`

	// hdr name
	HdrName string `json:"hdr_name,omitempty"`

	// hint format
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	HintFormat string `json:"hint_format,omitempty"`

	// hint name
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	HintName string `json:"hint_name,omitempty"`

	// log level
	// Enum: ["emerg","alert","crit","err","warning","notice","info","debug","silent"]
	// +kubebuilder:validation:Enum=emerg;alert;crit;err;warning;notice;info;debug;silent;
	LogLevel string `json:"log_level,omitempty"`

	// lua action
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	LuaAction string `json:"lua_action,omitempty"`

	// lua params
	LuaParams string `json:"lua_params,omitempty"`

	// map file
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	MapFile string `json:"map_file,omitempty"`

	// map keyfmt
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	MapKeyfmt string `json:"map_keyfmt,omitempty"`

	// map valuefmt
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	MapValuefmt string `json:"map_valuefmt,omitempty"`

	// mark value
	// Pattern: ^(0x[0-9A-Fa-f]+|[0-9]+)$
	// +kubebuilder:validation:Pattern=`^(0x[0-9A-Fa-f]+|[0-9]+)$`
	MarkValue string `json:"mark_value,omitempty"`

	// method fmt
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	MethodFmt string `json:"method_fmt,omitempty"`

	// nice value
	// Maximum: 1024
	// Minimum: -1024
	// +kubebuilder:validation:Maximum=1024
	// +kubebuilder:validation:Minimum=-1024
	NiceValue int64 `json:"nice_value,omitempty"`

	// normalizer
	// Enum: ["fragment-encode","fragment-strip","path-merge-slashes","path-strip-dot","path-strip-dotdot","percent-decode-unreserved","percent-to-uppercase","query-sort-by-name"]
	// +kubebuilder:validation:Enum=fragment-encode;fragment-strip;path-merge-slashes;path-strip-dot;path-strip-dotdot;percent-decode-unreserved;percent-to-uppercase;query-sort-by-name;
	Normalizer string `json:"normalizer,omitempty"`

	// normalizer full
	NormalizerFull bool `json:"normalizer_full,omitempty"`

	// normalizer strict
	NormalizerStrict bool `json:"normalizer_strict,omitempty"`

	// path fmt
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	PathFmt string `json:"path_fmt,omitempty"`

	// path match
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	PathMatch string `json:"path_match,omitempty"`

	// protocol
	// Enum: ["ipv4","ipv6"]
	// +kubebuilder:validation:Enum=ipv4;ipv6;
	Protocol string `json:"protocol,omitempty"`

	// query fmt
	QueryFmt string `json:"query-fmt,omitempty"`

	// redir code
	// Enum: [301,302,303,307,308]
	// +kubebuilder:validation:Enum=301;302;303;307;308;
	RedirCode *int64 `json:"redir_code,omitempty"`

	// redir option
	RedirOption string `json:"redir_option,omitempty"`

	// redir type
	// Enum: ["location","prefix","scheme"]
	// +kubebuilder:validation:Enum=location;prefix;scheme;
	RedirType string `json:"redir_type,omitempty"`

	// redir value
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	RedirValue string `json:"redir_value,omitempty"`

	// resolvers
	Resolvers string `json:"resolvers,omitempty"`

	// return content
	ReturnContent string `json:"return_content,omitempty"`

	// return content format
	// Enum: ["default-errorfiles","errorfile","errorfiles","file","lf-file","string","lf-string"]
	// +kubebuilder:validation:Enum=default-errorfiles;errorfile;errorfiles;file;lf-file;string;lf-string;
	ReturnContentFormat string `json:"return_content_format,omitempty"`

	// return content type
	ReturnContentType *string `json:"return_content_type,omitempty"`

	// return status code
	// Maximum: 599
	// Minimum: 200
	// +kubebuilder:validation:Maximum=599
	// +kubebuilder:validation:Minimum=200
	ReturnStatusCode *int64 `json:"return_status_code,omitempty"`

	// rst ttl
	RstTTL int64 `json:"rst_ttl,omitempty"`

	// sc expr
	ScExpr string `json:"sc_expr,omitempty"`

	// sc id
	ScID int64 `json:"sc_id,omitempty"`

	// sc idx
	ScIdx int64 `json:"sc_idx,omitempty"`

	// sc int
	ScInt *int64 `json:"sc_int,omitempty"`

	// service name
	ServiceName string `json:"service_name,omitempty"`

	// spoe engine
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	SpoeEngine string `json:"spoe_engine,omitempty"`

	// spoe group
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	SpoeGroup string `json:"spoe_group,omitempty"`

	// strict mode
	// Enum: ["on","off"]
	// +kubebuilder:validation:Enum=on;off;
	StrictMode string `json:"strict_mode,omitempty"`

	// timeout
	Timeout string `json:"timeout,omitempty"`

	// timeout type
	// Enum: ["server","tunnel","client"]
	// +kubebuilder:validation:Enum=server;tunnel;client;
	TimeoutType string `json:"timeout_type,omitempty"`

	// tos value
	// Pattern: ^(0x[0-9A-Fa-f]+|[0-9]+)$
	// +kubebuilder:validation:Pattern=`^(0x[0-9A-Fa-f]+|[0-9]+)$`
	TosValue string `json:"tos_value,omitempty"`

	// track sc key
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	TrackScKey string `json:"track_sc_key,omitempty"`

	// track sc stick counter
	TrackScStickCounter *int64 `json:"track_sc_stick_counter,omitempty"`

	// track sc table
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	TrackScTable string `json:"track_sc_table,omitempty"`

	// type
	// Required: true
	// Enum: ["add-acl","add-header","allow","auth","cache-use","capture","del-acl","del-header","del-map","deny","disable-l7-retry","do-resolve","early-hint","lua","normalize-uri","redirect","reject","replace-header","replace-path","replace-pathq","replace-uri","replace-value","return","sc-add-gpc","sc-inc-gpc","sc-inc-gpc0","sc-inc-gpc1","sc-set-gpt","sc-set-gpt0","send-spoe-group","set-bc-mark","set-bc-tos","set-dst","set-dst-port","set-fc-mark","set-fc-tos","set-header","set-log-level","set-map","set-mark","set-method","set-nice","set-path","set-pathq","set-priority-class","set-priority-offset","set-query","set-src","set-src-port","set-timeout","set-tos","set-uri","set-var","set-var-fmt","silent-drop","strict-mode","tarpit","track-sc","unset-var","use-service","wait-for-body","wait-for-handshake","set-bandwidth-limit","set-retries","do-log"]
	// +kubebuilder:validation:Enum=add-acl;add-header;allow;auth;cache-use;capture;del-acl;del-header;del-map;deny;disable-l7-retry;do-resolve;early-hint;lua;normalize-uri;redirect;reject;replace-header;replace-path;replace-pathq;replace-uri;replace-value;return;sc-add-gpc;sc-inc-gpc;sc-inc-gpc0;sc-inc-gpc1;sc-set-gpt;sc-set-gpt0;send-spoe-group;set-bc-mark;set-bc-tos;set-dst;set-dst-port;set-fc-mark;set-fc-tos;set-header;set-log-level;set-map;set-mark;set-method;set-nice;set-path;set-pathq;set-priority-class;set-priority-offset;set-query;set-src;set-src-port;set-timeout;set-tos;set-uri;set-var;set-var-fmt;silent-drop;strict-mode;tarpit;track-sc;unset-var;use-service;wait-for-body;wait-for-handshake;set-bandwidth-limit;set-retries;do-log;
	Type string `json:"type"`

	// uri fmt
	URIFmt string `json:"uri-fmt,omitempty"`

	// uri match
	URIMatch string `json:"uri-match,omitempty"`

	// var expr
	VarExpr string `json:"var_expr,omitempty"`

	// var format
	VarFormat string `json:"var_format,omitempty"`

	// var name
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	VarName string `json:"var_name,omitempty"`

	// var scope
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	VarScope string `json:"var_scope,omitempty"`

	// wait at least
	WaitAtLeast *int64 `json:"wait_at_least,omitempty"`

	// wait time
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	WaitTime *int64 `json:"wait_time,omitempty"`
}

// Validate validates this http request rule
func (m *HTTPRequestRule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateReturnHeaders(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateACLFile(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateACLKeyfmt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAuthRealm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCacheName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCaptureSample(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCond(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDenyStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHintFormat(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHintName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogLevel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLuaAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMapFile(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMapKeyfmt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMapValuefmt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMarkValue(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMethodFmt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNiceValue(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNormalizer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePathFmt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePathMatch(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRedirCode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRedirType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRedirValue(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReturnContentFormat(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReturnStatusCode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpoeEngine(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpoeGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStrictMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimeoutType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTosValue(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTrackScKey(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTrackScTable(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVarName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVarScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWaitTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HTTPRequestRule) validateReturnHeaders(formats strfmt.Registry) error {
	if swag.IsZero(m.ReturnHeaders) { // not required
		return nil
	}

	for i := 0; i < len(m.ReturnHeaders); i++ {
		if swag.IsZero(m.ReturnHeaders[i]) { // not required
			continue
		}

		if m.ReturnHeaders[i] != nil {
			if err := m.ReturnHeaders[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("return_hdrs" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("return_hdrs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HTTPRequestRule) validateACLFile(formats strfmt.Registry) error {
	if swag.IsZero(m.ACLFile) { // not required
		return nil
	}

	if err := validate.Pattern("acl_file", "body", m.ACLFile, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateACLKeyfmt(formats strfmt.Registry) error {
	if swag.IsZero(m.ACLKeyfmt) { // not required
		return nil
	}

	if err := validate.Pattern("acl_keyfmt", "body", m.ACLKeyfmt, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateAuthRealm(formats strfmt.Registry) error {
	if swag.IsZero(m.AuthRealm) { // not required
		return nil
	}

	if err := validate.Pattern("auth_realm", "body", m.AuthRealm, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateCacheName(formats strfmt.Registry) error {
	if swag.IsZero(m.CacheName) { // not required
		return nil
	}

	if err := validate.Pattern("cache_name", "body", m.CacheName, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateCaptureSample(formats strfmt.Registry) error {
	if swag.IsZero(m.CaptureSample) { // not required
		return nil
	}

	if err := validate.Pattern("capture_sample", "body", m.CaptureSample, `^(?:[A-Za-z]+\("([A-Za-z\s]+)"\)|[A-Za-z]+)`); err != nil {
		return err
	}

	return nil
}

var httpRequestRuleTypeCondPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["if","unless"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		httpRequestRuleTypeCondPropEnum = append(httpRequestRuleTypeCondPropEnum, v)
	}
}

const (

	// HTTPRequestRuleCondIf captures enum value "if"
	HTTPRequestRuleCondIf string = "if"

	// HTTPRequestRuleCondUnless captures enum value "unless"
	HTTPRequestRuleCondUnless string = "unless"
)

// prop value enum
func (m *HTTPRequestRule) validateCondEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, httpRequestRuleTypeCondPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *HTTPRequestRule) validateCond(formats strfmt.Registry) error {
	if swag.IsZero(m.Cond) { // not required
		return nil
	}

	// value enum
	if err := m.validateCondEnum("cond", "body", m.Cond); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateDenyStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.DenyStatus) { // not required
		return nil
	}

	if err := validate.MinimumInt("deny_status", "body", *m.DenyStatus, 200, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("deny_status", "body", *m.DenyStatus, 599, false); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateHintFormat(formats strfmt.Registry) error {
	if swag.IsZero(m.HintFormat) { // not required
		return nil
	}

	if err := validate.Pattern("hint_format", "body", m.HintFormat, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateHintName(formats strfmt.Registry) error {
	if swag.IsZero(m.HintName) { // not required
		return nil
	}

	if err := validate.Pattern("hint_name", "body", m.HintName, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var httpRequestRuleTypeLogLevelPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["emerg","alert","crit","err","warning","notice","info","debug","silent"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		httpRequestRuleTypeLogLevelPropEnum = append(httpRequestRuleTypeLogLevelPropEnum, v)
	}
}

const (

	// HTTPRequestRuleLogLevelEmerg captures enum value "emerg"
	HTTPRequestRuleLogLevelEmerg string = "emerg"

	// HTTPRequestRuleLogLevelAlert captures enum value "alert"
	HTTPRequestRuleLogLevelAlert string = "alert"

	// HTTPRequestRuleLogLevelCrit captures enum value "crit"
	HTTPRequestRuleLogLevelCrit string = "crit"

	// HTTPRequestRuleLogLevelErr captures enum value "err"
	HTTPRequestRuleLogLevelErr string = "err"

	// HTTPRequestRuleLogLevelWarning captures enum value "warning"
	HTTPRequestRuleLogLevelWarning string = "warning"

	// HTTPRequestRuleLogLevelNotice captures enum value "notice"
	HTTPRequestRuleLogLevelNotice string = "notice"

	// HTTPRequestRuleLogLevelInfo captures enum value "info"
	HTTPRequestRuleLogLevelInfo string = "info"

	// HTTPRequestRuleLogLevelDebug captures enum value "debug"
	HTTPRequestRuleLogLevelDebug string = "debug"

	// HTTPRequestRuleLogLevelSilent captures enum value "silent"
	HTTPRequestRuleLogLevelSilent string = "silent"
)

// prop value enum
func (m *HTTPRequestRule) validateLogLevelEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, httpRequestRuleTypeLogLevelPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *HTTPRequestRule) validateLogLevel(formats strfmt.Registry) error {
	if swag.IsZero(m.LogLevel) { // not required
		return nil
	}

	// value enum
	if err := m.validateLogLevelEnum("log_level", "body", m.LogLevel); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateLuaAction(formats strfmt.Registry) error {
	if swag.IsZero(m.LuaAction) { // not required
		return nil
	}

	if err := validate.Pattern("lua_action", "body", m.LuaAction, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateMapFile(formats strfmt.Registry) error {
	if swag.IsZero(m.MapFile) { // not required
		return nil
	}

	if err := validate.Pattern("map_file", "body", m.MapFile, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateMapKeyfmt(formats strfmt.Registry) error {
	if swag.IsZero(m.MapKeyfmt) { // not required
		return nil
	}

	if err := validate.Pattern("map_keyfmt", "body", m.MapKeyfmt, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateMapValuefmt(formats strfmt.Registry) error {
	if swag.IsZero(m.MapValuefmt) { // not required
		return nil
	}

	if err := validate.Pattern("map_valuefmt", "body", m.MapValuefmt, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateMarkValue(formats strfmt.Registry) error {
	if swag.IsZero(m.MarkValue) { // not required
		return nil
	}

	if err := validate.Pattern("mark_value", "body", m.MarkValue, `^(0x[0-9A-Fa-f]+|[0-9]+)$`); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateMethodFmt(formats strfmt.Registry) error {
	if swag.IsZero(m.MethodFmt) { // not required
		return nil
	}

	if err := validate.Pattern("method_fmt", "body", m.MethodFmt, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateNiceValue(formats strfmt.Registry) error {
	if swag.IsZero(m.NiceValue) { // not required
		return nil
	}

	if err := validate.MinimumInt("nice_value", "body", m.NiceValue, -1024, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("nice_value", "body", m.NiceValue, 1024, false); err != nil {
		return err
	}

	return nil
}

var httpRequestRuleTypeNormalizerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fragment-encode","fragment-strip","path-merge-slashes","path-strip-dot","path-strip-dotdot","percent-decode-unreserved","percent-to-uppercase","query-sort-by-name"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		httpRequestRuleTypeNormalizerPropEnum = append(httpRequestRuleTypeNormalizerPropEnum, v)
	}
}

const (

	// HTTPRequestRuleNormalizerFragmentDashEncode captures enum value "fragment-encode"
	HTTPRequestRuleNormalizerFragmentDashEncode string = "fragment-encode"

	// HTTPRequestRuleNormalizerFragmentDashStrip captures enum value "fragment-strip"
	HTTPRequestRuleNormalizerFragmentDashStrip string = "fragment-strip"

	// HTTPRequestRuleNormalizerPathDashMergeDashSlashes captures enum value "path-merge-slashes"
	HTTPRequestRuleNormalizerPathDashMergeDashSlashes string = "path-merge-slashes"

	// HTTPRequestRuleNormalizerPathDashStripDashDot captures enum value "path-strip-dot"
	HTTPRequestRuleNormalizerPathDashStripDashDot string = "path-strip-dot"

	// HTTPRequestRuleNormalizerPathDashStripDashDotdot captures enum value "path-strip-dotdot"
	HTTPRequestRuleNormalizerPathDashStripDashDotdot string = "path-strip-dotdot"

	// HTTPRequestRuleNormalizerPercentDashDecodeDashUnreserved captures enum value "percent-decode-unreserved"
	HTTPRequestRuleNormalizerPercentDashDecodeDashUnreserved string = "percent-decode-unreserved"

	// HTTPRequestRuleNormalizerPercentDashToDashUppercase captures enum value "percent-to-uppercase"
	HTTPRequestRuleNormalizerPercentDashToDashUppercase string = "percent-to-uppercase"

	// HTTPRequestRuleNormalizerQueryDashSortDashByDashName captures enum value "query-sort-by-name"
	HTTPRequestRuleNormalizerQueryDashSortDashByDashName string = "query-sort-by-name"
)

// prop value enum
func (m *HTTPRequestRule) validateNormalizerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, httpRequestRuleTypeNormalizerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *HTTPRequestRule) validateNormalizer(formats strfmt.Registry) error {
	if swag.IsZero(m.Normalizer) { // not required
		return nil
	}

	// value enum
	if err := m.validateNormalizerEnum("normalizer", "body", m.Normalizer); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validatePathFmt(formats strfmt.Registry) error {
	if swag.IsZero(m.PathFmt) { // not required
		return nil
	}

	if err := validate.Pattern("path_fmt", "body", m.PathFmt, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validatePathMatch(formats strfmt.Registry) error {
	if swag.IsZero(m.PathMatch) { // not required
		return nil
	}

	if err := validate.Pattern("path_match", "body", m.PathMatch, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var httpRequestRuleTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ipv4","ipv6"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		httpRequestRuleTypeProtocolPropEnum = append(httpRequestRuleTypeProtocolPropEnum, v)
	}
}

const (

	// HTTPRequestRuleProtocolIPV4 captures enum value "ipv4"
	HTTPRequestRuleProtocolIPV4 string = "ipv4"

	// HTTPRequestRuleProtocolIPV6 captures enum value "ipv6"
	HTTPRequestRuleProtocolIPV6 string = "ipv6"
)

// prop value enum
func (m *HTTPRequestRule) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, httpRequestRuleTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *HTTPRequestRule) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("protocol", "body", m.Protocol); err != nil {
		return err
	}

	return nil
}

var httpRequestRuleTypeRedirCodePropEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[301,302,303,307,308]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		httpRequestRuleTypeRedirCodePropEnum = append(httpRequestRuleTypeRedirCodePropEnum, v)
	}
}

// prop value enum
func (m *HTTPRequestRule) validateRedirCodeEnum(path, location string, value int64) error {
	if err := validate.EnumCase(path, location, value, httpRequestRuleTypeRedirCodePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *HTTPRequestRule) validateRedirCode(formats strfmt.Registry) error {
	if swag.IsZero(m.RedirCode) { // not required
		return nil
	}

	// value enum
	if err := m.validateRedirCodeEnum("redir_code", "body", *m.RedirCode); err != nil {
		return err
	}

	return nil
}

var httpRequestRuleTypeRedirTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["location","prefix","scheme"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		httpRequestRuleTypeRedirTypePropEnum = append(httpRequestRuleTypeRedirTypePropEnum, v)
	}
}

const (

	// HTTPRequestRuleRedirTypeLocation captures enum value "location"
	HTTPRequestRuleRedirTypeLocation string = "location"

	// HTTPRequestRuleRedirTypePrefix captures enum value "prefix"
	HTTPRequestRuleRedirTypePrefix string = "prefix"

	// HTTPRequestRuleRedirTypeScheme captures enum value "scheme"
	HTTPRequestRuleRedirTypeScheme string = "scheme"
)

// prop value enum
func (m *HTTPRequestRule) validateRedirTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, httpRequestRuleTypeRedirTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *HTTPRequestRule) validateRedirType(formats strfmt.Registry) error {
	if swag.IsZero(m.RedirType) { // not required
		return nil
	}

	// value enum
	if err := m.validateRedirTypeEnum("redir_type", "body", m.RedirType); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateRedirValue(formats strfmt.Registry) error {
	if swag.IsZero(m.RedirValue) { // not required
		return nil
	}

	if err := validate.Pattern("redir_value", "body", m.RedirValue, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var httpRequestRuleTypeReturnContentFormatPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["default-errorfiles","errorfile","errorfiles","file","lf-file","string","lf-string"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		httpRequestRuleTypeReturnContentFormatPropEnum = append(httpRequestRuleTypeReturnContentFormatPropEnum, v)
	}
}

const (

	// HTTPRequestRuleReturnContentFormatDefaultDashErrorfiles captures enum value "default-errorfiles"
	HTTPRequestRuleReturnContentFormatDefaultDashErrorfiles string = "default-errorfiles"

	// HTTPRequestRuleReturnContentFormatErrorfile captures enum value "errorfile"
	HTTPRequestRuleReturnContentFormatErrorfile string = "errorfile"

	// HTTPRequestRuleReturnContentFormatErrorfiles captures enum value "errorfiles"
	HTTPRequestRuleReturnContentFormatErrorfiles string = "errorfiles"

	// HTTPRequestRuleReturnContentFormatFile captures enum value "file"
	HTTPRequestRuleReturnContentFormatFile string = "file"

	// HTTPRequestRuleReturnContentFormatLfDashFile captures enum value "lf-file"
	HTTPRequestRuleReturnContentFormatLfDashFile string = "lf-file"

	// HTTPRequestRuleReturnContentFormatString captures enum value "string"
	HTTPRequestRuleReturnContentFormatString string = "string"

	// HTTPRequestRuleReturnContentFormatLfDashString captures enum value "lf-string"
	HTTPRequestRuleReturnContentFormatLfDashString string = "lf-string"
)

// prop value enum
func (m *HTTPRequestRule) validateReturnContentFormatEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, httpRequestRuleTypeReturnContentFormatPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *HTTPRequestRule) validateReturnContentFormat(formats strfmt.Registry) error {
	if swag.IsZero(m.ReturnContentFormat) { // not required
		return nil
	}

	// value enum
	if err := m.validateReturnContentFormatEnum("return_content_format", "body", m.ReturnContentFormat); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateReturnStatusCode(formats strfmt.Registry) error {
	if swag.IsZero(m.ReturnStatusCode) { // not required
		return nil
	}

	if err := validate.MinimumInt("return_status_code", "body", *m.ReturnStatusCode, 200, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("return_status_code", "body", *m.ReturnStatusCode, 599, false); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateSpoeEngine(formats strfmt.Registry) error {
	if swag.IsZero(m.SpoeEngine) { // not required
		return nil
	}

	if err := validate.Pattern("spoe_engine", "body", m.SpoeEngine, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateSpoeGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.SpoeGroup) { // not required
		return nil
	}

	if err := validate.Pattern("spoe_group", "body", m.SpoeGroup, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var httpRequestRuleTypeStrictModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["on","off"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		httpRequestRuleTypeStrictModePropEnum = append(httpRequestRuleTypeStrictModePropEnum, v)
	}
}

const (

	// HTTPRequestRuleStrictModeOn captures enum value "on"
	HTTPRequestRuleStrictModeOn string = "on"

	// HTTPRequestRuleStrictModeOff captures enum value "off"
	HTTPRequestRuleStrictModeOff string = "off"
)

// prop value enum
func (m *HTTPRequestRule) validateStrictModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, httpRequestRuleTypeStrictModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *HTTPRequestRule) validateStrictMode(formats strfmt.Registry) error {
	if swag.IsZero(m.StrictMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateStrictModeEnum("strict_mode", "body", m.StrictMode); err != nil {
		return err
	}

	return nil
}

var httpRequestRuleTypeTimeoutTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["server","tunnel","client"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		httpRequestRuleTypeTimeoutTypePropEnum = append(httpRequestRuleTypeTimeoutTypePropEnum, v)
	}
}

const (

	// HTTPRequestRuleTimeoutTypeServer captures enum value "server"
	HTTPRequestRuleTimeoutTypeServer string = "server"

	// HTTPRequestRuleTimeoutTypeTunnel captures enum value "tunnel"
	HTTPRequestRuleTimeoutTypeTunnel string = "tunnel"

	// HTTPRequestRuleTimeoutTypeClient captures enum value "client"
	HTTPRequestRuleTimeoutTypeClient string = "client"
)

// prop value enum
func (m *HTTPRequestRule) validateTimeoutTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, httpRequestRuleTypeTimeoutTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *HTTPRequestRule) validateTimeoutType(formats strfmt.Registry) error {
	if swag.IsZero(m.TimeoutType) { // not required
		return nil
	}

	// value enum
	if err := m.validateTimeoutTypeEnum("timeout_type", "body", m.TimeoutType); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateTosValue(formats strfmt.Registry) error {
	if swag.IsZero(m.TosValue) { // not required
		return nil
	}

	if err := validate.Pattern("tos_value", "body", m.TosValue, `^(0x[0-9A-Fa-f]+|[0-9]+)$`); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateTrackScKey(formats strfmt.Registry) error {
	if swag.IsZero(m.TrackScKey) { // not required
		return nil
	}

	if err := validate.Pattern("track_sc_key", "body", m.TrackScKey, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateTrackScTable(formats strfmt.Registry) error {
	if swag.IsZero(m.TrackScTable) { // not required
		return nil
	}

	if err := validate.Pattern("track_sc_table", "body", m.TrackScTable, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var httpRequestRuleTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["add-acl","add-header","allow","auth","cache-use","capture","del-acl","del-header","del-map","deny","disable-l7-retry","do-resolve","early-hint","lua","normalize-uri","redirect","reject","replace-header","replace-path","replace-pathq","replace-uri","replace-value","return","sc-add-gpc","sc-inc-gpc","sc-inc-gpc0","sc-inc-gpc1","sc-set-gpt","sc-set-gpt0","send-spoe-group","set-bc-mark","set-bc-tos","set-dst","set-dst-port","set-fc-mark","set-fc-tos","set-header","set-log-level","set-map","set-mark","set-method","set-nice","set-path","set-pathq","set-priority-class","set-priority-offset","set-query","set-src","set-src-port","set-timeout","set-tos","set-uri","set-var","set-var-fmt","silent-drop","strict-mode","tarpit","track-sc","unset-var","use-service","wait-for-body","wait-for-handshake","set-bandwidth-limit","set-retries","do-log"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		httpRequestRuleTypeTypePropEnum = append(httpRequestRuleTypeTypePropEnum, v)
	}
}

const (

	// HTTPRequestRuleTypeAddDashACL captures enum value "add-acl"
	HTTPRequestRuleTypeAddDashACL string = "add-acl"

	// HTTPRequestRuleTypeAddDashHeader captures enum value "add-header"
	HTTPRequestRuleTypeAddDashHeader string = "add-header"

	// HTTPRequestRuleTypeAllow captures enum value "allow"
	HTTPRequestRuleTypeAllow string = "allow"

	// HTTPRequestRuleTypeAuth captures enum value "auth"
	HTTPRequestRuleTypeAuth string = "auth"

	// HTTPRequestRuleTypeCacheDashUse captures enum value "cache-use"
	HTTPRequestRuleTypeCacheDashUse string = "cache-use"

	// HTTPRequestRuleTypeCapture captures enum value "capture"
	HTTPRequestRuleTypeCapture string = "capture"

	// HTTPRequestRuleTypeDelDashACL captures enum value "del-acl"
	HTTPRequestRuleTypeDelDashACL string = "del-acl"

	// HTTPRequestRuleTypeDelDashHeader captures enum value "del-header"
	HTTPRequestRuleTypeDelDashHeader string = "del-header"

	// HTTPRequestRuleTypeDelDashMap captures enum value "del-map"
	HTTPRequestRuleTypeDelDashMap string = "del-map"

	// HTTPRequestRuleTypeDeny captures enum value "deny"
	HTTPRequestRuleTypeDeny string = "deny"

	// HTTPRequestRuleTypeDisableDashL7DashRetry captures enum value "disable-l7-retry"
	HTTPRequestRuleTypeDisableDashL7DashRetry string = "disable-l7-retry"

	// HTTPRequestRuleTypeDoDashResolve captures enum value "do-resolve"
	HTTPRequestRuleTypeDoDashResolve string = "do-resolve"

	// HTTPRequestRuleTypeEarlyDashHint captures enum value "early-hint"
	HTTPRequestRuleTypeEarlyDashHint string = "early-hint"

	// HTTPRequestRuleTypeLua captures enum value "lua"
	HTTPRequestRuleTypeLua string = "lua"

	// HTTPRequestRuleTypeNormalizeDashURI captures enum value "normalize-uri"
	HTTPRequestRuleTypeNormalizeDashURI string = "normalize-uri"

	// HTTPRequestRuleTypeRedirect captures enum value "redirect"
	HTTPRequestRuleTypeRedirect string = "redirect"

	// HTTPRequestRuleTypeReject captures enum value "reject"
	HTTPRequestRuleTypeReject string = "reject"

	// HTTPRequestRuleTypeReplaceDashHeader captures enum value "replace-header"
	HTTPRequestRuleTypeReplaceDashHeader string = "replace-header"

	// HTTPRequestRuleTypeReplaceDashPath captures enum value "replace-path"
	HTTPRequestRuleTypeReplaceDashPath string = "replace-path"

	// HTTPRequestRuleTypeReplaceDashPathq captures enum value "replace-pathq"
	HTTPRequestRuleTypeReplaceDashPathq string = "replace-pathq"

	// HTTPRequestRuleTypeReplaceDashURI captures enum value "replace-uri"
	HTTPRequestRuleTypeReplaceDashURI string = "replace-uri"

	// HTTPRequestRuleTypeReplaceDashValue captures enum value "replace-value"
	HTTPRequestRuleTypeReplaceDashValue string = "replace-value"

	// HTTPRequestRuleTypeReturn captures enum value "return"
	HTTPRequestRuleTypeReturn string = "return"

	// HTTPRequestRuleTypeScDashAddDashGpc captures enum value "sc-add-gpc"
	HTTPRequestRuleTypeScDashAddDashGpc string = "sc-add-gpc"

	// HTTPRequestRuleTypeScDashIncDashGpc captures enum value "sc-inc-gpc"
	HTTPRequestRuleTypeScDashIncDashGpc string = "sc-inc-gpc"

	// HTTPRequestRuleTypeScDashIncDashGpc0 captures enum value "sc-inc-gpc0"
	HTTPRequestRuleTypeScDashIncDashGpc0 string = "sc-inc-gpc0"

	// HTTPRequestRuleTypeScDashIncDashGpc1 captures enum value "sc-inc-gpc1"
	HTTPRequestRuleTypeScDashIncDashGpc1 string = "sc-inc-gpc1"

	// HTTPRequestRuleTypeScDashSetDashGpt captures enum value "sc-set-gpt"
	HTTPRequestRuleTypeScDashSetDashGpt string = "sc-set-gpt"

	// HTTPRequestRuleTypeScDashSetDashGpt0 captures enum value "sc-set-gpt0"
	HTTPRequestRuleTypeScDashSetDashGpt0 string = "sc-set-gpt0"

	// HTTPRequestRuleTypeSendDashSpoeDashGroup captures enum value "send-spoe-group"
	HTTPRequestRuleTypeSendDashSpoeDashGroup string = "send-spoe-group"

	// HTTPRequestRuleTypeSetDashBcDashMark captures enum value "set-bc-mark"
	HTTPRequestRuleTypeSetDashBcDashMark string = "set-bc-mark"

	// HTTPRequestRuleTypeSetDashBcDashTos captures enum value "set-bc-tos"
	HTTPRequestRuleTypeSetDashBcDashTos string = "set-bc-tos"

	// HTTPRequestRuleTypeSetDashDst captures enum value "set-dst"
	HTTPRequestRuleTypeSetDashDst string = "set-dst"

	// HTTPRequestRuleTypeSetDashDstDashPort captures enum value "set-dst-port"
	HTTPRequestRuleTypeSetDashDstDashPort string = "set-dst-port"

	// HTTPRequestRuleTypeSetDashFcDashMark captures enum value "set-fc-mark"
	HTTPRequestRuleTypeSetDashFcDashMark string = "set-fc-mark"

	// HTTPRequestRuleTypeSetDashFcDashTos captures enum value "set-fc-tos"
	HTTPRequestRuleTypeSetDashFcDashTos string = "set-fc-tos"

	// HTTPRequestRuleTypeSetDashHeader captures enum value "set-header"
	HTTPRequestRuleTypeSetDashHeader string = "set-header"

	// HTTPRequestRuleTypeSetDashLogDashLevel captures enum value "set-log-level"
	HTTPRequestRuleTypeSetDashLogDashLevel string = "set-log-level"

	// HTTPRequestRuleTypeSetDashMap captures enum value "set-map"
	HTTPRequestRuleTypeSetDashMap string = "set-map"

	// HTTPRequestRuleTypeSetDashMark captures enum value "set-mark"
	HTTPRequestRuleTypeSetDashMark string = "set-mark"

	// HTTPRequestRuleTypeSetDashMethod captures enum value "set-method"
	HTTPRequestRuleTypeSetDashMethod string = "set-method"

	// HTTPRequestRuleTypeSetDashNice captures enum value "set-nice"
	HTTPRequestRuleTypeSetDashNice string = "set-nice"

	// HTTPRequestRuleTypeSetDashPath captures enum value "set-path"
	HTTPRequestRuleTypeSetDashPath string = "set-path"

	// HTTPRequestRuleTypeSetDashPathq captures enum value "set-pathq"
	HTTPRequestRuleTypeSetDashPathq string = "set-pathq"

	// HTTPRequestRuleTypeSetDashPriorityDashClass captures enum value "set-priority-class"
	HTTPRequestRuleTypeSetDashPriorityDashClass string = "set-priority-class"

	// HTTPRequestRuleTypeSetDashPriorityDashOffset captures enum value "set-priority-offset"
	HTTPRequestRuleTypeSetDashPriorityDashOffset string = "set-priority-offset"

	// HTTPRequestRuleTypeSetDashQuery captures enum value "set-query"
	HTTPRequestRuleTypeSetDashQuery string = "set-query"

	// HTTPRequestRuleTypeSetDashSrc captures enum value "set-src"
	HTTPRequestRuleTypeSetDashSrc string = "set-src"

	// HTTPRequestRuleTypeSetDashSrcDashPort captures enum value "set-src-port"
	HTTPRequestRuleTypeSetDashSrcDashPort string = "set-src-port"

	// HTTPRequestRuleTypeSetDashTimeout captures enum value "set-timeout"
	HTTPRequestRuleTypeSetDashTimeout string = "set-timeout"

	// HTTPRequestRuleTypeSetDashTos captures enum value "set-tos"
	HTTPRequestRuleTypeSetDashTos string = "set-tos"

	// HTTPRequestRuleTypeSetDashURI captures enum value "set-uri"
	HTTPRequestRuleTypeSetDashURI string = "set-uri"

	// HTTPRequestRuleTypeSetDashVar captures enum value "set-var"
	HTTPRequestRuleTypeSetDashVar string = "set-var"

	// HTTPRequestRuleTypeSetDashVarDashFmt captures enum value "set-var-fmt"
	HTTPRequestRuleTypeSetDashVarDashFmt string = "set-var-fmt"

	// HTTPRequestRuleTypeSilentDashDrop captures enum value "silent-drop"
	HTTPRequestRuleTypeSilentDashDrop string = "silent-drop"

	// HTTPRequestRuleTypeStrictDashMode captures enum value "strict-mode"
	HTTPRequestRuleTypeStrictDashMode string = "strict-mode"

	// HTTPRequestRuleTypeTarpit captures enum value "tarpit"
	HTTPRequestRuleTypeTarpit string = "tarpit"

	// HTTPRequestRuleTypeTrackDashSc captures enum value "track-sc"
	HTTPRequestRuleTypeTrackDashSc string = "track-sc"

	// HTTPRequestRuleTypeUnsetDashVar captures enum value "unset-var"
	HTTPRequestRuleTypeUnsetDashVar string = "unset-var"

	// HTTPRequestRuleTypeUseDashService captures enum value "use-service"
	HTTPRequestRuleTypeUseDashService string = "use-service"

	// HTTPRequestRuleTypeWaitDashForDashBody captures enum value "wait-for-body"
	HTTPRequestRuleTypeWaitDashForDashBody string = "wait-for-body"

	// HTTPRequestRuleTypeWaitDashForDashHandshake captures enum value "wait-for-handshake"
	HTTPRequestRuleTypeWaitDashForDashHandshake string = "wait-for-handshake"

	// HTTPRequestRuleTypeSetDashBandwidthDashLimit captures enum value "set-bandwidth-limit"
	HTTPRequestRuleTypeSetDashBandwidthDashLimit string = "set-bandwidth-limit"

	// HTTPRequestRuleTypeSetDashRetries captures enum value "set-retries"
	HTTPRequestRuleTypeSetDashRetries string = "set-retries"

	// HTTPRequestRuleTypeDoDashLog captures enum value "do-log"
	HTTPRequestRuleTypeDoDashLog string = "do-log"
)

// prop value enum
func (m *HTTPRequestRule) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, httpRequestRuleTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *HTTPRequestRule) validateType(formats strfmt.Registry) error {

	if err := validate.RequiredString("type", "body", m.Type); err != nil {
		return err
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateVarName(formats strfmt.Registry) error {
	if swag.IsZero(m.VarName) { // not required
		return nil
	}

	if err := validate.Pattern("var_name", "body", m.VarName, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateVarScope(formats strfmt.Registry) error {
	if swag.IsZero(m.VarScope) { // not required
		return nil
	}

	if err := validate.Pattern("var_scope", "body", m.VarScope, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *HTTPRequestRule) validateWaitTime(formats strfmt.Registry) error {
	if swag.IsZero(m.WaitTime) { // not required
		return nil
	}

	if err := validate.MinimumInt("wait_time", "body", *m.WaitTime, 0, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this http request rule based on the context it is used
func (m *HTTPRequestRule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReturnHeaders(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HTTPRequestRule) contextValidateReturnHeaders(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ReturnHeaders); i++ {

		if m.ReturnHeaders[i] != nil {

			if swag.IsZero(m.ReturnHeaders[i]) { // not required
				return nil
			}

			if err := m.ReturnHeaders[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("return_hdrs" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("return_hdrs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HTTPRequestRule) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HTTPRequestRule) UnmarshalBinary(b []byte) error {
	var res HTTPRequestRule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
