# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_pk_global_optspecs
	string join \n v/verbose q/quiet color= config= h/help V/version
end

function __fish_pk_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_pk_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_pk_using_subcommand
	set -l cmd (__fish_pk_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c pk -n "__fish_pk_needs_command" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_needs_command" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_needs_command" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_needs_command" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_needs_command" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_needs_command" -s V -l version -d 'Print version'
complete -c pk -n "__fish_pk_needs_command" -f -a "completion" -d 'Generate shell completion'
complete -c pk -n "__fish_pk_needs_command" -f -a "cpv" -d 'Cpv commands'
complete -c pk -n "__fish_pk_needs_command" -f -a "dep" -d 'Dependency commands'
complete -c pk -n "__fish_pk_needs_command" -f -a "pkg" -d 'Package commands'
complete -c pk -n "__fish_pk_needs_command" -f -a "repo" -d 'Repository commands'
complete -c pk -n "__fish_pk_needs_command" -f -a "version" -d 'Version commands'
complete -c pk -n "__fish_pk_using_subcommand completion" -s d -l dir -d 'Target directory for completion files' -r
complete -c pk -n "__fish_pk_using_subcommand completion" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand completion" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand completion" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand completion" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand completion" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand cpv; and not __fish_seen_subcommand_from compare intersect parse set sort" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand cpv; and not __fish_seen_subcommand_from compare intersect parse set sort" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand cpv; and not __fish_seen_subcommand_from compare intersect parse set sort" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand cpv; and not __fish_seen_subcommand_from compare intersect parse set sort" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand cpv; and not __fish_seen_subcommand_from compare intersect parse set sort" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand cpv; and not __fish_seen_subcommand_from compare intersect parse set sort" -f -a "compare" -d 'Compare two cpvs'
complete -c pk -n "__fish_pk_using_subcommand cpv; and not __fish_seen_subcommand_from compare intersect parse set sort" -f -a "intersect" -d 'Determine if a cpv intersects another value'
complete -c pk -n "__fish_pk_using_subcommand cpv; and not __fish_seen_subcommand_from compare intersect parse set sort" -f -a "parse" -d 'Parse cpv and optionally print formatted output'
complete -c pk -n "__fish_pk_using_subcommand cpv; and not __fish_seen_subcommand_from compare intersect parse set sort" -f -a "set" -d 'Collapse cpvs into a set'
complete -c pk -n "__fish_pk_using_subcommand cpv; and not __fish_seen_subcommand_from compare intersect parse set sort" -f -a "sort" -d 'Sort cpvs'
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from compare" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from compare" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from compare" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from compare" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from compare" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from intersect" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from intersect" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from intersect" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from intersect" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from intersect" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from parse" -s f -l format -d 'Output using a custom format' -r
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from parse" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from parse" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from parse" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from parse" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from parse" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from set" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from set" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from set" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from set" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from set" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from sort" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from sort" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from sort" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from sort" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand cpv; and __fish_seen_subcommand_from sort" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand dep; and not __fish_seen_subcommand_from compare intersect parse set sort" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand dep; and not __fish_seen_subcommand_from compare intersect parse set sort" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand dep; and not __fish_seen_subcommand_from compare intersect parse set sort" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand dep; and not __fish_seen_subcommand_from compare intersect parse set sort" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand dep; and not __fish_seen_subcommand_from compare intersect parse set sort" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand dep; and not __fish_seen_subcommand_from compare intersect parse set sort" -f -a "compare" -d 'Compare two deps'
complete -c pk -n "__fish_pk_using_subcommand dep; and not __fish_seen_subcommand_from compare intersect parse set sort" -f -a "intersect" -d 'Determine if a dep intersects another value'
complete -c pk -n "__fish_pk_using_subcommand dep; and not __fish_seen_subcommand_from compare intersect parse set sort" -f -a "parse" -d 'Parse a dep and optionally print formatted output'
complete -c pk -n "__fish_pk_using_subcommand dep; and not __fish_seen_subcommand_from compare intersect parse set sort" -f -a "set" -d 'Collapse deps into a set'
complete -c pk -n "__fish_pk_using_subcommand dep; and not __fish_seen_subcommand_from compare intersect parse set sort" -f -a "sort" -d 'Sort deps'
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from compare" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from compare" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from compare" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from compare" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from compare" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from intersect" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from intersect" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from intersect" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from intersect" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from intersect" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from parse" -l eapi -d 'Use a specific EAPI' -r
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from parse" -s f -l format -d 'Output using a custom format' -r
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from parse" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from parse" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from parse" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from parse" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from parse" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from set" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from set" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from set" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from set" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from set" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from sort" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from sort" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from sort" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from sort" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand dep; and __fish_seen_subcommand_from sort" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand pkg; and not __fish_seen_subcommand_from env fetch manifest metadata pretend revdeps showkw source" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand pkg; and not __fish_seen_subcommand_from env fetch manifest metadata pretend revdeps showkw source" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and not __fish_seen_subcommand_from env fetch manifest metadata pretend revdeps showkw source" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand pkg; and not __fish_seen_subcommand_from env fetch manifest metadata pretend revdeps showkw source" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand pkg; and not __fish_seen_subcommand_from env fetch manifest metadata pretend revdeps showkw source" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand pkg; and not __fish_seen_subcommand_from env fetch manifest metadata pretend revdeps showkw source" -f -a "env" -d 'Output ebuild environment'
complete -c pk -n "__fish_pk_using_subcommand pkg; and not __fish_seen_subcommand_from env fetch manifest metadata pretend revdeps showkw source" -f -a "fetch" -d 'Fetch distfiles'
complete -c pk -n "__fish_pk_using_subcommand pkg; and not __fish_seen_subcommand_from env fetch manifest metadata pretend revdeps showkw source" -f -a "manifest" -d 'Update manifests'
complete -c pk -n "__fish_pk_using_subcommand pkg; and not __fish_seen_subcommand_from env fetch manifest metadata pretend revdeps showkw source" -f -a "metadata" -d 'Manipulate package metadata'
complete -c pk -n "__fish_pk_using_subcommand pkg; and not __fish_seen_subcommand_from env fetch manifest metadata pretend revdeps showkw source" -f -a "pretend" -d 'Run the pkg_pretend phase'
complete -c pk -n "__fish_pk_using_subcommand pkg; and not __fish_seen_subcommand_from env fetch manifest metadata pretend revdeps showkw source" -f -a "revdeps" -d 'Output reverse dependencies'
complete -c pk -n "__fish_pk_using_subcommand pkg; and not __fish_seen_subcommand_from env fetch manifest metadata pretend revdeps showkw source" -f -a "showkw" -d 'Output package keywords'
complete -c pk -n "__fish_pk_using_subcommand pkg; and not __fish_seen_subcommand_from env fetch manifest metadata pretend revdeps showkw source" -f -a "source" -d 'Benchmark ebuild sourcing'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from env" -s f -l filter -d 'Variable filtering' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from env" -s r -l repo -d 'Target repo' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from env" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from env" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from env" -s i -l ignore -d 'Ignore invalid packages'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from env" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from env" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from env" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from fetch" -s c -l concurrent -d 'Concurrent downloads' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from fetch" -s d -l dir -d 'Download directory' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from fetch" -s F -l filter -d 'Filter URLs via regex' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from fetch" -s t -l timeout -d 'Connection timeout in seconds' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from fetch" -s r -l repo -d 'Target repo' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from fetch" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from fetch" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from fetch" -s f -l force -d 'Overwrite existing files'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from fetch" -s i -l ignore -d 'Ignore invalid packages'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from fetch" -s I -l insecure -d 'Ignore invalid service certificates'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from fetch" -s m -l mirrors -d 'Try fetching from default mirrors'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from fetch" -s n -l no-progress -d 'Disable progress output'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from fetch" -s p -l pretend -d 'Output targets instead of fetching them'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from fetch" -l restrict -d 'Process fetch-restricted URLS'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from fetch" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from fetch" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from fetch" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from manifest" -s c -l concurrent -d 'Concurrent downloads' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from manifest" -s d -l dir -d 'Download directory' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from manifest" -s t -l timeout -d 'Connection timeout in seconds' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from manifest" -s r -l repo -d 'Target repo' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from manifest" -l thick -d 'Force manifest type' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from manifest" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from manifest" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from manifest" -s f -l force -d 'Force remanifest'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from manifest" -s i -l insecure -d 'Ignore invalid service certificates'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from manifest" -s m -l mirrors -d 'Try fetching from default mirrors'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from manifest" -s n -l no-progress -d 'Disable progress output'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from manifest" -l stdout -d 'Output to stdout'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from manifest" -l restrict -d 'Process fetch-restricted URLS'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from manifest" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from manifest" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from manifest" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from metadata" -s j -l jobs -d 'Parallel jobs to run' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from metadata" -s p -l path -d 'Custom cache path' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from metadata" -l format -d 'Custom cache format' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from metadata" -s r -l repo -d 'Target repo' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from metadata" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from metadata" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from metadata" -s f -l force -d 'Force regeneration to occur'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from metadata" -s V -l verify -d 'Verify metadata without updating cache'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from metadata" -s R -l remove -d 'Remove cache entries'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from metadata" -s n -l no-progress -d 'Disable progress bar'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from metadata" -s o -l output -d 'Capture stderr and stdout'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from metadata" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from metadata" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from metadata" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from pretend" -s r -l repo -d 'Target repo' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from pretend" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from pretend" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from pretend" -s i -l ignore -d 'Ignore invalid packages'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from pretend" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from pretend" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from pretend" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from revdeps" -s r -l repo -d 'Target repository' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from revdeps" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from revdeps" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from revdeps" -s i -l ignore -d 'Ignore invalid packages'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from revdeps" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from revdeps" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from revdeps" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from showkw" -s r -l repo -d 'Target repo' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from showkw" -s a -l arches -d 'Target arches' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from showkw" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from showkw" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from showkw" -s i -l ignore -d 'Ignore invalid packages'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from showkw" -s p -l prefix -d 'Show prefix arches'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from showkw" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from showkw" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from showkw" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from source" -s j -l jobs -d 'Parallel jobs to run' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from source" -s b -l bench -d 'Benchmark for a duration' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from source" -s B -l bound -d 'Apply bounds to elapsed time' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from source" -s r -l repo -d 'Target repo' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from source" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from source" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from source" -l sort -d 'Sort output in ascending order for elapsed time'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from source" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from source" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand pkg; and __fish_seen_subcommand_from source" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand repo; and not __fish_seen_subcommand_from eapi eclass leaf license metadata mirror revdeps" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand repo; and not __fish_seen_subcommand_from eapi eclass leaf license metadata mirror revdeps" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand repo; and not __fish_seen_subcommand_from eapi eclass leaf license metadata mirror revdeps" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand repo; and not __fish_seen_subcommand_from eapi eclass leaf license metadata mirror revdeps" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand repo; and not __fish_seen_subcommand_from eapi eclass leaf license metadata mirror revdeps" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand repo; and not __fish_seen_subcommand_from eapi eclass leaf license metadata mirror revdeps" -f -a "eapi" -d 'Output EAPI statistics'
complete -c pk -n "__fish_pk_using_subcommand repo; and not __fish_seen_subcommand_from eapi eclass leaf license metadata mirror revdeps" -f -a "eclass" -d 'Output eclass statistics'
complete -c pk -n "__fish_pk_using_subcommand repo; and not __fish_seen_subcommand_from eapi eclass leaf license metadata mirror revdeps" -f -a "leaf" -d 'Output leaf packages'
complete -c pk -n "__fish_pk_using_subcommand repo; and not __fish_seen_subcommand_from eapi eclass leaf license metadata mirror revdeps" -f -a "license" -d 'Output license statistics'
complete -c pk -n "__fish_pk_using_subcommand repo; and not __fish_seen_subcommand_from eapi eclass leaf license metadata mirror revdeps" -f -a "metadata" -d 'Manipulate repo metadata'
complete -c pk -n "__fish_pk_using_subcommand repo; and not __fish_seen_subcommand_from eapi eclass leaf license metadata mirror revdeps" -f -a "mirror" -d 'Output mirror statistics'
complete -c pk -n "__fish_pk_using_subcommand repo; and not __fish_seen_subcommand_from eapi eclass leaf license metadata mirror revdeps" -f -a "revdeps" -d 'Output revdeps cache'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from eapi" -l eapi -d 'Output packages for a target EAPI' -r
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from eapi" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from eapi" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from eapi" -s i -l ignore -d 'Ignore invalid packages'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from eapi" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from eapi" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from eapi" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from eclass" -l eclass -d 'Output packages for a target eclass' -r
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from eclass" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from eclass" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from eclass" -s i -l ignore -d 'Ignore invalid packages'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from eclass" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from eclass" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from eclass" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from leaf" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from leaf" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from leaf" -s i -l ignore -d 'Ignore invalid packages'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from leaf" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from leaf" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from leaf" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from license" -l licenses -d 'Output packages for target licenses' -r
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from license" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from license" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from license" -s i -l ignore -d 'Ignore invalid packages'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from license" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from license" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from license" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from metadata" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from metadata" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from metadata" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from metadata" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from metadata" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from metadata" -f -a "clean" -d 'Clean metadata cache'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from metadata" -f -a "regen" -d 'Regenerate metadata cache'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from metadata" -f -a "remove" -d 'Remove metadata cache'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from mirror" -l mirror -d 'Output packages for a target mirror' -r
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from mirror" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from mirror" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from mirror" -s i -l ignore -d 'Ignore invalid packages'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from mirror" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from mirror" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from mirror" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from revdeps" -s d -l dir -d 'Target directory' -r
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from revdeps" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from revdeps" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from revdeps" -s i -l ignore -d 'Ignore invalid packages'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from revdeps" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from revdeps" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand repo; and __fish_seen_subcommand_from revdeps" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand version; and not __fish_seen_subcommand_from compare intersect parse set sort" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand version; and not __fish_seen_subcommand_from compare intersect parse set sort" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand version; and not __fish_seen_subcommand_from compare intersect parse set sort" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand version; and not __fish_seen_subcommand_from compare intersect parse set sort" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand version; and not __fish_seen_subcommand_from compare intersect parse set sort" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand version; and not __fish_seen_subcommand_from compare intersect parse set sort" -f -a "compare" -d 'Compare two versions'
complete -c pk -n "__fish_pk_using_subcommand version; and not __fish_seen_subcommand_from compare intersect parse set sort" -f -a "intersect" -d 'Determine if two versions intersect'
complete -c pk -n "__fish_pk_using_subcommand version; and not __fish_seen_subcommand_from compare intersect parse set sort" -f -a "parse" -d 'Parse a version and optionally print formatted output'
complete -c pk -n "__fish_pk_using_subcommand version; and not __fish_seen_subcommand_from compare intersect parse set sort" -f -a "set" -d 'Collapse versions into a set'
complete -c pk -n "__fish_pk_using_subcommand version; and not __fish_seen_subcommand_from compare intersect parse set sort" -f -a "sort" -d 'Sort versions'
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from compare" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from compare" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from compare" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from compare" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from compare" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from intersect" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from intersect" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from intersect" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from intersect" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from intersect" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from parse" -s f -l format -d 'Output using a custom format' -r
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from parse" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from parse" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from parse" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from parse" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from parse" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from set" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from set" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from set" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from set" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from set" -s h -l help -d 'Print help'
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from sort" -l color -d 'Enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from sort" -l config -d 'Use a custom config' -r
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from sort" -s v -l verbose -d 'Increase logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from sort" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pk -n "__fish_pk_using_subcommand version; and __fish_seen_subcommand_from sort" -s h -l help -d 'Print help'
