package bldr

import (
	"testing"

	"github.com/stretchr/testify/require"
	"google.golang.org/protobuf/types/known/structpb"

	"gitlab.com/gitlab-org/step-runner/pkg/runner"
)

type JobVariablesBuilder struct {
	t    *testing.T
	vars map[string]*structpb.Value
}

func JobVars(t *testing.T) *JobVariablesBuilder {
	return &JobVariablesBuilder{
		t:    t,
		vars: make(map[string]*structpb.Value),
	}
}

func (b *JobVariablesBuilder) WithValues(values map[string]string) *JobVariablesBuilder {
	for k, v := range values {
		b.WithValue(k, v)
	}

	return b
}

func (b *JobVariablesBuilder) WithValue(key string, value any) *JobVariablesBuilder {
	var err error
	b.vars[key], err = structpb.NewValue(value)
	require.NoError(b.t, err)

	return b
}

func (b *JobVariablesBuilder) Build() runner.JobVariables {
	return b.vars
}
