/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.accesscontrol;

import java.util.HashSet;
import java.util.Objects;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Weight;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.cache.query.QueryCache;
import org.elasticsearch.indices.IndicesQueryCache;
import org.elasticsearch.license.LicenseStateListener;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.authz.accesscontrol.FieldExtractor;

public final class OptOutQueryCache
extends AbstractIndexComponent
implements LicenseStateListener,
QueryCache {
    private final IndicesQueryCache indicesQueryCache;
    private final ThreadContext context;
    private final String indexName;
    private final XPackLicenseState licenseState;
    private volatile boolean licenseStateListenerRegistered;

    public OptOutQueryCache(IndexSettings indexSettings, IndicesQueryCache indicesQueryCache, ThreadContext context, XPackLicenseState licenseState) {
        super(indexSettings);
        this.indicesQueryCache = indicesQueryCache;
        this.context = Objects.requireNonNull(context, "threadContext must not be null");
        this.indexName = indexSettings.getIndex().getName();
        this.licenseState = Objects.requireNonNull(licenseState, "licenseState");
    }

    public void listenForLicenseStateChanges() {
        assert (!this.licenseStateListenerRegistered);
        this.licenseState.addListener((LicenseStateListener)this);
        this.licenseStateListenerRegistered = true;
    }

    public void close() throws ElasticsearchException {
        assert (this.licenseStateListenerRegistered);
        this.licenseState.removeListener((LicenseStateListener)this);
        this.clear("close");
    }

    public void licenseStateChanged() {
        assert (this.licenseStateListenerRegistered);
        this.clear("license state changed");
    }

    public void clear(String reason) {
        assert (this.licenseStateListenerRegistered);
        this.logger.debug("full cache clear, reason [{}]", (Object)reason);
        this.indicesQueryCache.clearIndex(this.index().getName());
    }

    public Weight doCache(Weight weight, QueryCachingPolicy policy) {
        assert (this.licenseStateListenerRegistered);
        if (!this.licenseState.isSecurityEnabled()) {
            this.logger.debug("not opting out of the query cache; authorization is not allowed");
            return this.indicesQueryCache.doCache(weight, policy);
        }
        IndicesAccessControl indicesAccessControl = (IndicesAccessControl)this.context.getTransient("_indices_permissions");
        if (indicesAccessControl == null) {
            this.logger.debug("opting out of the query cache. current request doesn't hold indices permissions");
            return weight;
        }
        IndicesAccessControl.IndexAccessControl indexAccessControl = indicesAccessControl.getIndexPermissions(this.indexName);
        if (indexAccessControl != null && indexAccessControl.getFieldPermissions().hasFieldLevelSecurity()) {
            if (OptOutQueryCache.cachingIsSafe(weight, indexAccessControl)) {
                this.logger.trace("not opting out of the query cache. request for index [{}] is safe to cache", (Object)this.indexName);
                return this.indicesQueryCache.doCache(weight, policy);
            }
            this.logger.trace("opting out of the query cache. request for index [{}] is unsafe to cache", (Object)this.indexName);
            return weight;
        }
        this.logger.trace("not opting out of the query cache. request for index [{}] has field level security disabled", (Object)this.indexName);
        return this.indicesQueryCache.doCache(weight, policy);
    }

    static boolean cachingIsSafe(Weight weight, IndicesAccessControl.IndexAccessControl permissions) {
        HashSet<String> fields = new HashSet<String>();
        try {
            FieldExtractor.extractFields(weight.getQuery(), fields);
        }
        catch (UnsupportedOperationException ok) {
            return false;
        }
        for (String field : fields) {
            if (!field.startsWith("_") && permissions.getFieldPermissions().grantsAccessTo(field)) continue;
            return false;
        }
        return true;
    }
}

