/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.aggregatemetric;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.List;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.xpack.aggregatemetric.AggregateMetricFeatureSet;
import org.elasticsearch.xpack.aggregatemetric.aggregations.metrics.AggregateMetricsAggregatorsRegistrar;
import org.elasticsearch.xpack.aggregatemetric.mapper.AggregateDoubleMetricFieldMapper;
import org.elasticsearch.xpack.core.XPackPlugin;

public class AggregateMetricMapperPlugin
extends Plugin
implements MapperPlugin,
ActionPlugin,
SearchPlugin {
    private final boolean transportClientMode;

    public AggregateMetricMapperPlugin(Settings settings) {
        this.transportClientMode = XPackPlugin.transportClientMode((Settings)settings);
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        if (this.transportClientMode) {
            return modules;
        }
        modules.add(b -> XPackPlugin.bindFeatureSet((Binder)b, AggregateMetricFeatureSet.class));
        return modules;
    }

    public Map<String, Mapper.TypeParser> getMappers() {
        return Collections.singletonMap("aggregate_metric_double", AggregateDoubleMetricFieldMapper.PARSER);
    }

    public java.util.List<Consumer<ValuesSourceRegistry.Builder>> getAggregationExtentions() {
        return List.of((Object[])new Consumer[]{AggregateMetricsAggregatorsRegistrar::registerSumAggregator, AggregateMetricsAggregatorsRegistrar::registerAvgAggregator, AggregateMetricsAggregatorsRegistrar::registerMinAggregator, AggregateMetricsAggregatorsRegistrar::registerMaxAggregator, AggregateMetricsAggregatorsRegistrar::registerValueCountAggregator});
    }
}

