/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.suggest.document.CompletionPostingsFormat;
import org.apache.lucene.search.suggest.document.CompletionTerms;
import org.apache.lucene.search.suggest.document.CompletionsTermsReader;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.IOUtils;

final class CompletionFieldsProducer
extends FieldsProducer {
    private FieldsProducer delegateFieldsProducer;
    private Map<String, CompletionsTermsReader> readers;
    private IndexInput dictIn;

    private CompletionFieldsProducer(FieldsProducer delegateFieldsProducer, Map<String, CompletionsTermsReader> readers) {
        this.delegateFieldsProducer = delegateFieldsProducer;
        this.readers = readers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CompletionFieldsProducer(String codecName, SegmentReadState state, CompletionPostingsFormat.FSTLoadMode fstLoadMode) throws IOException {
        String indexFile = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"cmp");
        this.delegateFieldsProducer = null;
        boolean success = false;
        try {
            try (ChecksumIndexInput index = state.directory.openChecksumInput(indexFile, state.context);){
                String dictFile = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"lkp");
                this.dictIn = state.directory.openInput(dictFile, state.context);
                CodecUtil.checkIndexHeader((DataInput)this.dictIn, (String)codecName, (int)1, (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                CodecUtil.retrieveChecksum((IndexInput)this.dictIn);
                CodecUtil.checkIndexHeader((DataInput)index, (String)codecName, (int)1, (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                PostingsFormat delegatePostingsFormat = PostingsFormat.forName((String)index.readString());
                this.delegateFieldsProducer = delegatePostingsFormat.fieldsProducer(state);
                int numFields = index.readVInt();
                this.readers = new HashMap<String, CompletionsTermsReader>(numFields);
                for (int i = 0; i < numFields; ++i) {
                    int fieldNumber = index.readVInt();
                    long offset = index.readVLong();
                    long minWeight = index.readVLong();
                    long maxWeight = index.readVLong();
                    byte type = index.readByte();
                    FieldInfo fieldInfo = state.fieldInfos.fieldInfo(fieldNumber);
                    this.readers.put(fieldInfo.name, new CompletionsTermsReader(this.dictIn, offset, minWeight, maxWeight, type, fstLoadMode));
                }
                CodecUtil.checkFooter((ChecksumIndexInput)index);
                success = true;
            }
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.delegateFieldsProducer, this.dictIn});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.delegateFieldsProducer, this.dictIn});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws IOException {
        boolean success = false;
        try {
            this.delegateFieldsProducer.close();
            IOUtils.close((Closeable[])new Closeable[]{this.dictIn});
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.delegateFieldsProducer, this.dictIn});
            throw throwable;
        }
    }

    public void checkIntegrity() throws IOException {
        this.delegateFieldsProducer.checkIntegrity();
    }

    public FieldsProducer getMergeInstance() {
        return new CompletionFieldsProducer(this.delegateFieldsProducer, this.readers);
    }

    public long ramBytesUsed() {
        long ramBytesUsed = this.delegateFieldsProducer.ramBytesUsed();
        for (CompletionsTermsReader reader : this.readers.values()) {
            ramBytesUsed += reader.ramBytesUsed();
        }
        return ramBytesUsed;
    }

    public Collection<Accountable> getChildResources() {
        ArrayList<Accountable> accountableList = new ArrayList<Accountable>();
        for (Map.Entry<String, CompletionsTermsReader> readerEntry : this.readers.entrySet()) {
            accountableList.add(Accountables.namedAccountable((String)readerEntry.getKey(), (Accountable)readerEntry.getValue()));
        }
        return Collections.unmodifiableCollection(accountableList);
    }

    public Iterator<String> iterator() {
        return this.readers.keySet().iterator();
    }

    public Terms terms(String field) throws IOException {
        Terms terms = this.delegateFieldsProducer.terms(field);
        if (terms == null) {
            return null;
        }
        return new CompletionTerms(terms, this.readers.get(field));
    }

    public int size() {
        return this.readers.size();
    }
}

