/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.ilm.PhaseCacheManagement;
import org.elasticsearch.xpack.core.ilm.action.PutLifecycleAction;
import org.elasticsearch.xpack.core.searchablesnapshots.SearchableSnapshotsConstants;

public class TransportPutLifecycleAction
extends TransportMasterNodeAction<PutLifecycleAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportPutLifecycleAction.class);
    private final NamedXContentRegistry xContentRegistry;
    private final Client client;
    private final XPackLicenseState licenseState;

    @Inject
    public TransportPutLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedXContentRegistry namedXContentRegistry, XPackLicenseState licenseState, Client client) {
        super("cluster:admin/ilm/put", transportService, clusterService, threadPool, actionFilters, PutLifecycleAction.Request::new, indexNameExpressionResolver, AcknowledgedResponse::readFrom, "same");
        this.xContentRegistry = namedXContentRegistry;
        this.licenseState = licenseState;
        this.client = client;
    }

    protected void masterOperation(final PutLifecycleAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        final Map filteredHeaders = ClientHelper.filterSecurityHeaders((Map)this.threadPool.getThreadContext().getHeaders());
        LifecyclePolicy.validatePolicyName((String)request.getPolicy().getName());
        List phasesDefiningSearchableSnapshot = request.getPolicy().getPhases().values().stream().filter(phase -> phase.getActions().containsKey("searchable_snapshot")).collect(Collectors.toList());
        if (!phasesDefiningSearchableSnapshot.isEmpty() && !SearchableSnapshotsConstants.SEARCHABLE_SNAPSHOT_FEATURE.checkWithoutTracking(this.licenseState)) {
            throw new IllegalArgumentException("policy [" + request.getPolicy().getName() + "] defines the [" + "searchable_snapshot" + "] action but the current license is non-compliant for [searchable-snapshots]");
        }
        this.clusterService.submitStateUpdateTask("put-lifecycle-" + request.getPolicy().getName(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask((AckedRequest)request, listener){

            public ClusterState execute(ClusterState currentState) throws Exception {
                LifecyclePolicyMetadata lifecyclePolicyMetadata;
                LifecyclePolicyMetadata existingPolicyMetadata;
                ClusterState.Builder stateBuilder = ClusterState.builder((ClusterState)currentState);
                IndexLifecycleMetadata currentMetadata = (IndexLifecycleMetadata)currentState.metadata().custom("index_lifecycle");
                if (currentMetadata == null) {
                    currentMetadata = IndexLifecycleMetadata.EMPTY;
                }
                long nextVersion = (existingPolicyMetadata = (LifecyclePolicyMetadata)currentMetadata.getPolicyMetadatas().get(request.getPolicy().getName())) == null ? 1L : existingPolicyMetadata.getVersion() + 1L;
                TreeMap<String, LifecyclePolicyMetadata> newPolicies = new TreeMap<String, LifecyclePolicyMetadata>(currentMetadata.getPolicyMetadatas());
                LifecyclePolicyMetadata oldPolicy = newPolicies.put((lifecyclePolicyMetadata = new LifecyclePolicyMetadata(request.getPolicy(), filteredHeaders, nextVersion, Instant.now().toEpochMilli())).getName(), lifecyclePolicyMetadata);
                if (oldPolicy == null) {
                    logger.info("adding index lifecycle policy [{}]", (Object)request.getPolicy().getName());
                } else {
                    logger.info("updating index lifecycle policy [{}]", (Object)request.getPolicy().getName());
                }
                IndexLifecycleMetadata newMetadata = new IndexLifecycleMetadata(newPolicies, currentMetadata.getOperationMode());
                stateBuilder.metadata(Metadata.builder((Metadata)currentState.getMetadata()).putCustom("index_lifecycle", (Metadata.Custom)newMetadata).build());
                ClusterState nonRefreshedState = stateBuilder.build();
                if (oldPolicy == null) {
                    return nonRefreshedState;
                }
                try {
                    return PhaseCacheManagement.updateIndicesForPolicy((ClusterState)nonRefreshedState, (NamedXContentRegistry)TransportPutLifecycleAction.this.xContentRegistry, (Client)TransportPutLifecycleAction.this.client, (LifecyclePolicy)oldPolicy.getPolicy(), (LifecyclePolicyMetadata)lifecyclePolicyMetadata, (XPackLicenseState)TransportPutLifecycleAction.this.licenseState);
                }
                catch (Exception e) {
                    logger.warn((Message)new ParameterizedMessage("unable to refresh indices phase JSON for updated policy [{}]", (Object)oldPolicy.getName()), (Throwable)e);
                    return nonRefreshedState;
                }
            }
        });
    }

    protected ClusterBlockException checkBlock(PutLifecycleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

