/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.transport.actions.activate;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.watcher.support.WatcherUtils;

public class ActivateWatchRequest
extends ActionRequest {
    private String watchId;
    private boolean activate;

    public ActivateWatchRequest() {
        this(null, true);
    }

    public ActivateWatchRequest(String watchId, boolean activate) {
        this.watchId = watchId;
        this.activate = activate;
    }

    public ActivateWatchRequest(StreamInput in) throws IOException {
        super(in);
        this.watchId = in.readString();
        this.activate = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.watchId);
        out.writeBoolean(this.activate);
    }

    public String getWatchId() {
        return this.watchId;
    }

    public boolean isActivate() {
        return this.activate;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.watchId == null) {
            validationException = ValidateActions.addValidationError((String)"watch id is missing", validationException);
        } else if (!WatcherUtils.isValidId(this.watchId)) {
            validationException = ValidateActions.addValidationError((String)"watch id contains whitespace", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String toString() {
        return this.activate ? "activate [" + this.watchId + "]" : "deactivate [" + this.watchId + "]";
    }
}

