/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class TrainedModelInput
implements ToXContentObject,
Writeable {
    public static final String NAME = "trained_model_config_input";
    public static final ParseField FIELD_NAMES = new ParseField("field_names", new String[0]);
    public static final ConstructingObjectParser<TrainedModelInput, Void> LENIENT_PARSER = TrainedModelInput.createParser(true);
    public static final ConstructingObjectParser<TrainedModelInput, Void> STRICT_PARSER = TrainedModelInput.createParser(false);
    private final List<String> fieldNames;

    public TrainedModelInput(List<String> fieldNames) {
        this.fieldNames = Collections.unmodifiableList(ExceptionsHelper.requireNonNull(fieldNames, FIELD_NAMES));
    }

    public TrainedModelInput(StreamInput in) throws IOException {
        this.fieldNames = Collections.unmodifiableList(in.readStringList());
    }

    private static ConstructingObjectParser<TrainedModelInput, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, ignoreUnknownFields, a -> new TrainedModelInput((List)a[0]));
        parser.declareStringArray(ConstructingObjectParser.constructorArg(), FIELD_NAMES);
        return parser;
    }

    public static TrainedModelInput fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? (TrainedModelInput)LENIENT_PARSER.parse(parser, null) : (TrainedModelInput)STRICT_PARSER.parse(parser, null);
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.fieldNames);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD_NAMES.getPreferredName(), this.fieldNames);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainedModelInput that = (TrainedModelInput)o;
        return Objects.equals(this.fieldNames, that.fieldNames);
    }

    public int hashCode() {
        return Objects.hash(this.fieldNames);
    }
}

