/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.cluster.routing.allocation.DataTierAllocationDecider;
import org.elasticsearch.xpack.core.ilm.AllocationRoutedStep;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.step.info.AllocationInfo;

public class DataTierMigrationRoutedStep
extends ClusterStateWaitStep {
    public static final String NAME = "check-migration";
    private static final Logger logger = LogManager.getLogger(DataTierMigrationRoutedStep.class);
    private static final Set<Setting<?>> ALL_CLUSTER_SETTINGS;

    DataTierMigrationRoutedStep(Step.StepKey key, Step.StepKey nextStepKey) {
        super(key, nextStepKey);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public ClusterStateWaitStep.Result isConditionMet(Index index, ClusterState clusterState) {
        AllocationDeciders allocationDeciders = new AllocationDeciders((Collection)org.elasticsearch.core.List.of((Object)((Object)new DataTierAllocationDecider(clusterState.getMetadata().settings(), new ClusterSettings(Settings.EMPTY, ALL_CLUSTER_SETTINGS)))));
        IndexMetadata idxMeta = clusterState.metadata().index(index);
        if (idxMeta == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().getAction(), (Object)index.getName());
            return new ClusterStateWaitStep.Result(false, null);
        }
        List preferredTierConfiguration = idxMeta.getTierPreference();
        Optional<String> availableDestinationTier = DataTierAllocationDecider.preferredAvailableTier(preferredTierConfiguration, clusterState.getNodes());
        if (!ActiveShardCount.ALL.enoughShardsActive(clusterState, new String[]{index.getName()})) {
            if (preferredTierConfiguration.isEmpty()) {
                logger.debug("[{}] lifecycle action for index [{}] cannot make progress because not all shards are active", (Object)this.getKey().getAction(), (Object)index.getName());
            } else if (availableDestinationTier.isPresent()) {
                logger.debug("[{}] migration of index [{}] to the {} tier preference cannot progress, as not all shards are active", (Object)this.getKey().getAction(), (Object)index.getName(), (Object)preferredTierConfiguration);
            } else {
                logger.debug("[{}] migration of index [{}] to the next tier cannot progress as there is no available tier for the configured preferred tiers {} and not all shards are active", (Object)this.getKey().getAction(), (Object)index.getName(), (Object)preferredTierConfiguration);
            }
            return new ClusterStateWaitStep.Result(false, AllocationInfo.waitingForActiveShardsAllocationInfo(idxMeta.getNumberOfReplicas()));
        }
        if (preferredTierConfiguration.isEmpty()) {
            logger.debug("index [{}] has no data tier routing preference setting configured and all its shards are active. considering the [{}] step condition met and continuing to the next step", (Object)index.getName(), (Object)this.getKey().getName());
            return new ClusterStateWaitStep.Result(true, null);
        }
        int allocationPendingAllShards = AllocationRoutedStep.getPendingAllocations(index, allocationDeciders, clusterState);
        if (allocationPendingAllShards > 0) {
            String statusMessage = availableDestinationTier.map(s -> String.format(Locale.ROOT, "[%s] lifecycle action [%s] waiting for [%s] shards to be moved to the [%s] tier (tier migration preference configuration is %s)", index.getName(), this.getKey().getAction(), allocationPendingAllShards, s, preferredTierConfiguration)).orElseGet(() -> String.format(Locale.ROOT, "index [%s] has a preference for tiers %s, but no nodes for any of those tiers are available in the cluster", index.getName(), preferredTierConfiguration));
            logger.debug(statusMessage);
            return new ClusterStateWaitStep.Result(false, new AllocationInfo(idxMeta.getNumberOfReplicas(), allocationPendingAllShards, true, statusMessage));
        }
        logger.debug("[{}] migration of index [{}] to tier [{}] (preference [{}]) complete", (Object)this.getKey().getAction(), (Object)index, (Object)availableDestinationTier.orElse(""), (Object)preferredTierConfiguration);
        return new ClusterStateWaitStep.Result(true, null);
    }

    static {
        HashSet allSettings = new HashSet(ClusterSettings.BUILT_IN_CLUSTER_SETTINGS);
        allSettings.add(DataTierAllocationDecider.CLUSTER_ROUTING_REQUIRE_SETTING);
        allSettings.add(DataTierAllocationDecider.CLUSTER_ROUTING_INCLUDE_SETTING);
        allSettings.add(DataTierAllocationDecider.CLUSTER_ROUTING_EXCLUDE_SETTING);
        ALL_CLUSTER_SETTINGS = allSettings;
    }
}

