/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.legacygeo.parsers;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.elasticsearch.legacygeo.builders.ShapeBuilder;
import org.elasticsearch.legacygeo.parsers.GeoJsonParser;
import org.elasticsearch.legacygeo.parsers.GeoWKTParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.support.MapXContentParser;

public interface ShapeParser {
    public static final ParseField FIELD_TYPE = new ParseField("type", new String[0]);
    public static final ParseField FIELD_COORDINATES = new ParseField("coordinates", new String[0]);
    public static final ParseField FIELD_GEOMETRIES = new ParseField("geometries", new String[0]);
    public static final ParseField FIELD_ORIENTATION = new ParseField("orientation", new String[0]);

    public static ShapeBuilder<?, ?, ?> parse(XContentParser parser, AbstractGeometryFieldMapper<?> geometryMapper) throws IOException {
        AbstractShapeGeometryFieldMapper shapeMapper = null;
        if (geometryMapper != null) {
            if (!(geometryMapper instanceof AbstractShapeGeometryFieldMapper)) {
                throw new IllegalArgumentException("geometry must be a shape type");
            }
            shapeMapper = (AbstractShapeGeometryFieldMapper)geometryMapper;
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            return GeoJsonParser.parse(parser, shapeMapper);
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            return GeoWKTParser.parse(parser, shapeMapper);
        }
        throw new ElasticsearchParseException("shape must be an object consisting of type and coordinates", new Object[0]);
    }

    public static ShapeBuilder<?, ?, ?> parse(XContentParser parser) throws IOException {
        return ShapeParser.parse(parser, null);
    }

    public static ShapeBuilder<?, ?, ?> parse(Object value) throws IOException {
        try (MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, Collections.singletonMap("value", value), null);){
            parser.nextToken();
            parser.nextToken();
            parser.nextToken();
            ShapeBuilder<?, ?, ?> shapeBuilder = ShapeParser.parse((XContentParser)parser);
            return shapeBuilder;
        }
    }
}

