/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.stats;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.ingest.geoip.stats.GeoIpDownloaderStats;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GeoIpDownloaderStatsAction
extends ActionType<Response> {
    public static final GeoIpDownloaderStatsAction INSTANCE = new GeoIpDownloaderStatsAction();
    public static final String NAME = "cluster:monitor/ingest/geoip/stats";

    public GeoIpDownloaderStatsAction() {
        super(NAME, Response::new);
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private final GeoIpDownloaderStats stats;
        private final Set<String> databases;
        private final Set<String> filesInTemp;

        protected NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.stats = in.readBoolean() ? new GeoIpDownloaderStats(in) : null;
            this.databases = in.readSet(StreamInput::readString);
            this.filesInTemp = in.readSet(StreamInput::readString);
        }

        protected NodeResponse(DiscoveryNode node, GeoIpDownloaderStats stats, Set<String> databases, Set<String> filesInTemp) {
            super(node);
            this.stats = stats;
            this.databases = databases;
            this.filesInTemp = filesInTemp;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.stats != null);
            if (this.stats != null) {
                this.stats.writeTo(out);
            }
            out.writeCollection(this.databases, StreamOutput::writeString);
            out.writeCollection(this.filesInTemp, StreamOutput::writeString);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            NodeResponse that = (NodeResponse)((Object)o);
            return this.stats.equals(that.stats) && this.databases.equals(that.databases) && this.filesInTemp.equals(that.filesInTemp);
        }

        public int hashCode() {
            return Objects.hash(this.stats, this.databases, this.filesInTemp);
        }
    }

    public static class Response
    extends BaseNodesResponse<NodeResponse>
    implements Writeable,
    ToXContentObject {
        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public Response(ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        protected List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeResponse::new);
        }

        protected void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) throws IOException {
            out.writeList(nodes);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            GeoIpDownloaderStats stats = this.getNodes().stream().map(n -> ((NodeResponse)n).stats).filter(Objects::nonNull).findFirst().orElse(GeoIpDownloaderStats.EMPTY);
            builder.startObject();
            builder.field("stats", (ToXContent)stats);
            builder.startObject("nodes");
            for (Map.Entry e : this.getNodesMap().entrySet()) {
                NodeResponse response = (NodeResponse)((Object)e.getValue());
                if (response.filesInTemp.isEmpty() && response.databases.isEmpty()) continue;
                builder.startObject((String)e.getKey());
                if (!response.databases.isEmpty()) {
                    builder.startArray("databases");
                    for (String database : response.databases) {
                        builder.startObject();
                        builder.field("name", database);
                        builder.endObject();
                    }
                    builder.endArray();
                }
                if (!response.filesInTemp.isEmpty()) {
                    builder.array("files_in_temp", response.filesInTemp.toArray(new String[0]));
                }
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)((Object)o);
            return Objects.equals(this.getNodes(), that.getNodes()) && Objects.equals(this.failures(), that.failures());
        }

        public int hashCode() {
            return Objects.hash(this.getNodes(), this.failures());
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        public NodeRequest(StreamInput in) throws IOException {
            super(in);
        }

        public NodeRequest(Request request) {
        }
    }

    public static class Request
    extends BaseNodesRequest<Request>
    implements ToXContentObject {
        public Request() {
            super((String[])null);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hashCode(GeoIpDownloaderStatsAction.NAME);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return ((Object)((Object)this)).getClass() == obj.getClass();
        }
    }
}

