/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.sql.action.SqlQueryRequest;
import org.elasticsearch.xpack.sql.plugin.TextFormat;
import org.elasticsearch.xpack.sql.proto.Mode;

public class SqlMediaTypeParser {
    public static SqlMediaType getResponseMediaType(RestRequest request, SqlQueryRequest sqlRequest) {
        if (Mode.isDedicatedClient((Mode)sqlRequest.requestInfo().mode()) && (sqlRequest.binaryCommunication() == null || sqlRequest.binaryCommunication().booleanValue())) {
            return SqlMediaType.xContentType(XContentType.CBOR);
        }
        if (request.hasParam("format")) {
            return SqlMediaTypeParser.validateColumnarRequest(sqlRequest.columnar(), SqlMediaTypeParser.mediaTypeFromParams(request), request);
        }
        return SqlMediaTypeParser.mediaTypeFromHeaders(request);
    }

    public static SqlMediaType getResponseMediaType(RestRequest request) {
        return request.hasParam("format") ? SqlMediaTypeParser.checkNonNullMediaType(SqlMediaTypeParser.mediaTypeFromParams(request), request) : SqlMediaTypeParser.mediaTypeFromHeaders(request);
    }

    private static SqlMediaType mediaTypeFromHeaders(RestRequest request) {
        String acceptType = SqlMediaTypeParser.getAcceptValue(request);
        SqlMediaType mediaType = acceptType != null ? SqlMediaType.fromMediaTypeOrFormat(acceptType) : SqlMediaType.xContentType(request.getXContentType());
        return SqlMediaTypeParser.checkNonNullMediaType(mediaType, request);
    }

    private static SqlMediaType mediaTypeFromParams(RestRequest request) {
        return SqlMediaType.fromMediaTypeOrFormat(request.param("format"));
    }

    private static SqlMediaType validateColumnarRequest(boolean requestIsColumnar, SqlMediaType fromMediaType, RestRequest request) {
        if (requestIsColumnar && fromMediaType.isTextFormat()) {
            throw new IllegalArgumentException("Invalid use of [columnar] argument: cannot be used in combination with txt, csv or tsv formats");
        }
        return SqlMediaTypeParser.checkNonNullMediaType(fromMediaType, request);
    }

    private static SqlMediaType checkNonNullMediaType(SqlMediaType mediaType, RestRequest request) {
        if (mediaType == null) {
            String msg = String.format(Locale.ROOT, "Invalid request content type: Accept=[%s], Content-Type=[%s], format=[%s]", request.header("Accept"), request.header("Content-Type"), request.param("format"));
            throw new IllegalArgumentException(msg);
        }
        return mediaType;
    }

    @Nullable
    private static String getAcceptValue(RestRequest request) {
        Map headers = request.getHeaders();
        String headerName = "Accept";
        List header = (List)headers.get("Accept");
        if (header == null || header.isEmpty()) {
            return null;
        }
        if (header.size() > 1) {
            throw new IllegalArgumentException("Incorrect header [Accept]. Only one value should be provided");
        }
        String rawContentType = (String)header.get(0);
        if (Strings.hasText((String)rawContentType)) {
            if ("*/*".equals(rawContentType)) {
                return null;
            }
            return rawContentType;
        }
        throw new IllegalArgumentException("Header [Accept] cannot be empty.");
    }

    static class SqlMediaType {
        private final XContentType xContentType;
        private final TextFormat textFormat;
        private final boolean isTextFormat;

        private SqlMediaType(XContentType xContentType, TextFormat textFormat) {
            this.xContentType = xContentType;
            this.textFormat = textFormat;
            this.isTextFormat = textFormat != null;
        }

        private static SqlMediaType xContentType(XContentType xContentType) {
            return xContentType != null ? new SqlMediaType(xContentType, null) : null;
        }

        private static SqlMediaType textFormat(TextFormat textFormat) {
            return textFormat != null ? new SqlMediaType(null, textFormat) : null;
        }

        boolean isTextFormat() {
            return this.isTextFormat;
        }

        XContentType xContentType() {
            return this.xContentType;
        }

        TextFormat textFormat() {
            return this.textFormat;
        }

        private static SqlMediaType fromMediaTypeOrFormat(String mediaType) {
            XContentType xContentType = XContentType.fromMediaTypeOrFormat((String)mediaType);
            return xContentType != null ? SqlMediaType.xContentType(xContentType) : SqlMediaType.textFormat(TextFormat.fromMediaTypeOrFormat(mediaType));
        }
    }
}

