/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.conditional;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Conditionals;

public class ConditionalProcessor
implements Processor {
    public static final String NAME = "nco";
    private final List<Processor> processors;
    private final ConditionalOperation operation;

    public ConditionalProcessor(List<Processor> processors, ConditionalOperation operation) {
        this.processors = processors;
        this.operation = operation;
    }

    public ConditionalProcessor(StreamInput in) throws IOException {
        this.processors = in.readNamedWriteableList(Processor.class);
        this.operation = (ConditionalOperation)in.readEnum(ConditionalOperation.class);
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteableList(this.processors);
        out.writeEnum((Enum)this.operation);
    }

    public Object process(Object input) {
        return this.operation.applyOnInput(this.processors, input);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionalProcessor that = (ConditionalProcessor)o;
        return Objects.equals(this.processors, that.processors) && this.operation == that.operation;
    }

    public int hashCode() {
        return Objects.hash(this.processors, this.operation);
    }

    public static enum ConditionalOperation implements Function<Collection<Object>, Object>
    {
        COALESCE(Conditionals::coalesce, Conditionals::coalesceInput),
        GREATEST(Conditionals::greatest, Conditionals::greatestInput),
        LEAST(Conditionals::least, Conditionals::leastInput);

        private final Function<Collection<Object>, Object> process;
        private final BiFunction<List<Processor>, Object, Object> inputProcess;

        String scriptMethodName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        private ConditionalOperation(Function<Collection<Object>, Object> process, BiFunction<List<Processor>, Object, Object> inputProcess) {
            this.process = process;
            this.inputProcess = inputProcess;
        }

        @Override
        public Object apply(Collection<Object> objects) {
            return this.process.apply(objects);
        }

        Object applyOnInput(List<Processor> processors, Object input) {
            return this.inputProcess.apply(processors, input);
        }
    }
}

