/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.math;

import java.io.IOException;
import java.util.Objects;
import java.util.function.BiFunction;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;

public class BinaryOptionalMathProcessor
implements Processor {
    private final Processor left;
    private final Processor right;
    private final BinaryOptionalMathOperation operation;
    public static final String NAME = "mob";

    public BinaryOptionalMathProcessor(Processor left, Processor right, BinaryOptionalMathOperation operation) {
        this.left = left;
        this.right = right;
        this.operation = operation;
    }

    public BinaryOptionalMathProcessor(StreamInput in) throws IOException {
        this.left = (Processor)in.readNamedWriteable(Processor.class);
        this.right = (Processor)in.readOptionalNamedWriteable(Processor.class);
        this.operation = (BinaryOptionalMathOperation)in.readEnum(BinaryOptionalMathOperation.class);
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.left);
        out.writeOptionalNamedWriteable((NamedWriteable)this.right);
        out.writeEnum((Enum)this.operation);
    }

    public Object process(Object input) {
        return this.doProcess(this.left().process(input), this.right() == null ? null : this.right().process(input));
    }

    public Number doProcess(Object left, Object right) {
        if (left == null) {
            return null;
        }
        if (!(left instanceof Number)) {
            throw new SqlIllegalArgumentException("A number is required; received [{}]", left);
        }
        if (right != null) {
            if (!(right instanceof Number)) {
                throw new SqlIllegalArgumentException("A number is required; received [{}]", right);
            }
            if (right instanceof Float || right instanceof Double) {
                throw new SqlIllegalArgumentException("An integer number is required; received [{}] as second parameter", right);
            }
        } else {
            right = 0;
        }
        return this.operation().apply((Number)left, (Number)right);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryOptionalMathProcessor other = (BinaryOptionalMathProcessor)obj;
        return Objects.equals(this.left(), other.left()) && Objects.equals(this.right(), other.right()) && Objects.equals(this.operation(), other.operation());
    }

    public int hashCode() {
        return Objects.hash(this.left(), this.right(), this.operation());
    }

    public Processor left() {
        return this.left;
    }

    public Processor right() {
        return this.right;
    }

    public BinaryOptionalMathOperation operation() {
        return this.operation;
    }

    public String getWriteableName() {
        return NAME;
    }

    public static enum BinaryOptionalMathOperation implements BiFunction<Number, Number, Number>
    {
        ROUND((l, r) -> {
            double tenAtScale = Math.pow(10.0, r.longValue());
            double middleResult = l.doubleValue() * tenAtScale;
            int sign = middleResult > 0.0 ? 1 : -1;
            return (double)Math.round(Math.abs(middleResult)) / tenAtScale * (double)sign;
        }),
        TRUNCATE((l, r) -> {
            double tenAtScale = Math.pow(10.0, r.longValue());
            double g = l.doubleValue() * tenAtScale;
            return (l.doubleValue() < 0.0 ? Math.ceil(g) : Math.floor(g)) / tenAtScale;
        });

        private final BiFunction<Number, Number, Number> process;

        private BinaryOptionalMathOperation(BiFunction<Number, Number, Number> process) {
            this.process = process;
        }

        @Override
        public final Number apply(Number left, Number right) {
            if (left == null) {
                return null;
            }
            if (!(left instanceof Number)) {
                throw new SqlIllegalArgumentException("A number is required; received [{}]", left);
            }
            if (right != null) {
                if (!(right instanceof Number)) {
                    throw new SqlIllegalArgumentException("A number is required; received [{}]", right);
                }
                if (right instanceof Float || right instanceof Double) {
                    throw new SqlIllegalArgumentException("An integer number is required; received [{}] as second parameter", right);
                }
            } else {
                right = 0;
            }
            return this.process.apply(left, right);
        }
    }
}

