# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/codegen/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the TestStep message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    #
    # *
    #  A `TestStep` is derived from either a `PickleStep`
    #  combined with a `StepDefinition`, or from a `Hook`.
    ##
    class TestStep < Message
      ##
      # Pointer to the `Hook` (if derived from a Hook)
      ##
      attr_reader :hook_id

      attr_reader :id

      ##
      # Pointer to the `PickleStep` (if derived from a `PickleStep`)
      ##
      attr_reader :pickle_step_id

      ##
      # Pointer to all the matching `StepDefinition`s (if derived from a `PickleStep`)
      #  Each element represents a matching step definition. A size of 0 means `UNDEFINED`,
      #  and a size of 2+ means `AMBIGUOUS`
      ##
      attr_reader :step_definition_ids

      ##
      # A list of list of StepMatchArgument (if derived from a `PickleStep`).
      ##
      attr_reader :step_match_arguments_lists

      def initialize(
        hook_id: nil,
        id: '',
        pickle_step_id: nil,
        step_definition_ids: nil,
        step_match_arguments_lists: nil
      )
        @hook_id = hook_id
        @id = id
        @pickle_step_id = pickle_step_id
        @step_definition_ids = step_definition_ids
        @step_match_arguments_lists = step_match_arguments_lists
        super()
      end

      ##
      # Returns a new TestStep from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::TestStep.from_h(some_hash) # => #<Cucumber::Messages::TestStep:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          hook_id: hash[:hookId],
          id: hash[:id],
          pickle_step_id: hash[:pickleStepId],
          step_definition_ids: hash[:stepDefinitionIds],
          step_match_arguments_lists: hash[:stepMatchArgumentsLists]&.map { |item| StepMatchArgumentsList.from_h(item) }
        )
      end
    end
  end
end
