# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/codegen/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the Duration message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    #
    # The structure is pretty close of the Timestamp one. For clarity, a second type
    #  of message is used.
    ##
    class Duration < Message
      attr_reader :seconds

      ##
      # Non-negative fractions of a second at nanosecond resolution. Negative
      #  second values with fractions must still have non-negative nanos values
      #  that count forward in time. Must be from 0 to 999,999,999
      #  inclusive.
      ##
      attr_reader :nanos

      def initialize(
        seconds: 0,
        nanos: 0
      )
        @seconds = seconds
        @nanos = nanos
        super()
      end

      ##
      # Returns a new Duration from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::Duration.from_h(some_hash) # => #<Cucumber::Messages::Duration:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          seconds: hash[:seconds],
          nanos: hash[:nanos]
        )
      end
    end
  end
end
