---
slug: 2.3.0
title: What's new in 2.3.0?
date: 2024-06-03T00:00:00.000Z
authors: orhun
tags:
  - release
---

<center>

  <a href="https://github.com/orhun/git-cliff">
    <img src="/img/git-cliff-anim.gif" />
  </a>

</center>

> [**git-cliff**](https://github.com/orhun/git-cliff) is a command-line tool (written in [Rust](https://www.rust-lang.org/)) that provides a highly customizable way to generate changelogs from git history.
>
> It supports using [custom regular expressions](/docs/configuration/git#commit_parsers) to alter changelogs which are mostly based on [conventional commits](/docs/configuration/git#conventional_commits). With a single [configuration file](/docs/configuration), a wide variety of formats can be applied for a changelog, thanks to the Jinja2/Django-inspired [template engine](/docs/category/templating).
>
> More information and examples can be found in the [GitHub repository](https://github.com/orhun/git-cliff).

## What's new? ⛰️

The full changelog can be found [here](https://github.com/orhun/git-cliff/blob/main/CHANGELOG.md).

---

### 🦊 GitLab Integration

`git-cliff` now supports integrating with repositories hosted on GitLab (gitlab.com or your own instance)!

This means that you can now use the following variables in your changelog:

- GitLab usernames (`${{ commit.gitlab.username }}` or `${{ contributor.username }}`)
- Contributors list (`${{ gitlab.contributors }}`)
- Pull requests (`${{ commit.gitlab.pr_number }}` or `${{ contributor.pr_number }}`)

Which means you can generate a changelog entries like the following:

```md
## What's Changed

- feat(commit): add merge_commit flag to the context by @orhun in !389
- test(fixture): add test fixture for bumping version by @orhun in !360

## New Contributors

- @someone made their first contribution in !360
- @cliffjumper made their first contribution in !389

<!-- generated by git-cliff -->
```

To set up `git-cliff` for your project, simply:

1. Check out the [quickstart guide](https://git-cliff.org/docs/) for installation / initialization.
1. Set up the [Git remote](https://git-cliff.org/docs/configuration/remote/) for your GitLab project.
1. Update the changelog configuration to use the [template variables](https://git-cliff.org/docs/integration/gitlab/).

:::tip

See the [GitLab integration](https://git-cliff.org/docs/integration/gitlab) for detailed documentation and usage examples. It works very similar to the [GitHub integration](https://git-cliff.org/docs/integration/github).

:::

Big thanks to [dark0dave](https://github.com/dark0dave) for the [contribution](https://github.com/orhun/git-cliff/issues/654)!

---

### 📘 Bitbucket Integration

`git-cliff` now supports integrating with repositories hosted on Bitbucket!

It works similarly with GitHub and GitLab integrations. See the [documentation](https://git-cliff.org/docs/integration/bitbucket) for details and usage examples.

Big thanks to [dark0dave](https://github.com/dark0dave) for the [contribution](https://github.com/orhun/git-cliff/issues/654)!

---

### 📤 Output to stdout

Using `-` for `stdout` is common among CLI tools and `git-cliff` now supports this!

```sh
$ git-cliff -o -
```

You can simply use `-` instead instead of `-o /dev/stdout`. It can also be used in conjunction with `-p` argument as mentioned in [this issue](https://github.com/orhun/git-cliff/issues/643).

---

### 🧰 Other

- _(nix)_ Add installation instructions for Nix ([#669](https://github.com/orhun/git-cliff/issues/669)) - ([63c8ad4](https://github.com/orhun/git-cliff/commit/63c8ad43e9ecaa825ef1f0a67164265497f3a1dd))
- _(website)_ Add more git range examples ([#655](https://github.com/orhun/git-cliff/issues/655)) - ([d451252](https://github.com/orhun/git-cliff/commit/d4512521fbcfb971c94aa7794d78bced1ddec7a1))
- _(args)_ Allow -o and -p together if they point to different files ([#653](https://github.com/orhun/git-cliff/issues/653)) - ([076f859](https://github.com/orhun/git-cliff/commit/076f85915386c4769c838ca9a359d216249d2a97))
- _(example)_ Allow using github template without github variables ([#672](https://github.com/orhun/git-cliff/issues/672)) - ([6a9feba](https://github.com/orhun/git-cliff/commit/6a9feba98f36de1980bab313f6b0a861f5009d71))

---

## Contributions 👥

- @R11baka made their first contribution in [#672](https://github.com/orhun/git-cliff/pull/672)
- @0x61nas made their first contribution in [#669](https://github.com/orhun/git-cliff/pull/669)
- @dark0dave made their first contribution in [#663](https://github.com/orhun/git-cliff/pull/663)
- @antonengelhardt made their first contribution in [#653](https://github.com/orhun/git-cliff/pull/653)

Any contribution is highly appreciated! See the [contribution guidelines](https://github.com/orhun/git-cliff/blob/main/CONTRIBUTING.md) for getting started.

Feel free to [submit issues](https://github.com/orhun/git-cliff/issues/new/choose) and join our [Discord](https://discord.gg/W3mAwMDWH4) / [Matrix](https://matrix.to/#/#git-cliff:matrix.org) for discussion!

Follow `git-cliff` on [Twitter](https://twitter.com/git_cliff) & [Mastodon](https://fosstodon.org/@git_cliff) to not miss any news!

## Support 🌟

If you liked `git-cliff` and/or my other projects [on GitHub](https://github.com/orhun), consider [donating](https://donate.orhun.dev) to support my open source endeavors.

- 💖 GitHub Sponsors: [@orhun](https://github.com/sponsors/orhun)
- ☕ Buy Me A Coffee: [https://www.buymeacoffee.com/orhun](https://www.buymeacoffee.com/orhun)

Have a fantastic day! ⛰️
