/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.support.operatordict;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.jeuclid.elements.support.operatordict.AbstractOperatorDictionary;
import net.sourceforge.jeuclid.elements.support.operatordict.OperatorAttribute;
import net.sourceforge.jeuclid.elements.support.operatordict.OperatorDictionary;
import net.sourceforge.jeuclid.elements.support.operatordict.OperatorForm;
import net.sourceforge.jeuclid.elements.support.operatordict.UnknownAttributeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class OperatorDictionary2
extends AbstractOperatorDictionary
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(OperatorDictionary2.class);
    private static final long serialVersionUID = 1L;
    private static final String DICTIONARY_FILE = "/net/sourceforge/jeuclid/moDictionary.xml";
    private static final String DICTIONARY_SERIALIZED = "/net/sourceforge/jeuclid/moDictionary.ser";
    private static OperatorDictionary instance;

    private OperatorDictionary2() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperatorDictionary getInstance() {
        Class<OperatorDictionary2> clazz = OperatorDictionary2.class;
        synchronized (OperatorDictionary2.class) {
            if (instance == null) {
                OperatorDictionary operatorDictionary = AbstractOperatorDictionary.deserialize(DICTIONARY_SERIALIZED);
                instance = operatorDictionary == null ? new OperatorDictionary2() : operatorDictionary;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initializeFromXML(Map<OperatorAttribute, Map<String, Map<OperatorForm, String>>> map) {
        InputStream inputStream = null;
        try {
            inputStream = OperatorDictionary2.class.getResourceAsStream(DICTIONARY_FILE);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            xMLReader.setContentHandler(new DictionaryReader(map));
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.warn((Object)("Cannot get SAXParser:" + parserConfigurationException.getMessage()));
        }
        catch (SAXException sAXException) {
            LOGGER.warn((Object)("SAXException while parsing dictionary:" + sAXException.getMessage()));
        }
        catch (IOException iOException) {
            LOGGER.warn((Object)"Read error while accessing XML dictionary", (Throwable)iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    LOGGER.warn((Object)"Error closing XML dictionary", (Throwable)iOException);
                }
            }
        }
    }

    private class DictionaryReader
    extends DefaultHandler {
        private static final String ELEMENT_ELEMENT = "element";
        private String currentOperator;
        private OperatorForm currentFormIndex;
        private Map<OperatorAttribute, String> currentEntry;
        private final Map<OperatorAttribute, Map<String, Map<OperatorForm, String>>> dict;

        public DictionaryReader(Map<OperatorAttribute, Map<String, Map<OperatorForm, String>>> map) {
            this.dict = map;
            this.currentEntry = null;
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals(ELEMENT_ELEMENT)) {
                this.currentEntry = new TreeMap<OperatorAttribute, String>();
                String string4 = attributes.getValue("form");
                if (string4 == null) {
                    LOGGER.fatal((Object)"Error in dictionary, attribute 'form' is required attribute for the dictionary");
                    this.currentFormIndex = OperatorForm.INFIX;
                } else {
                    this.currentFormIndex = OperatorForm.parseOperatorForm(string4);
                }
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string5 = attributes.getQName(i);
                    String string6 = attributes.getValue(i);
                    if (string5.equals("form")) continue;
                    try {
                        this.currentEntry.put(OperatorAttribute.parseOperatorAttribute(string5), string6);
                        continue;
                    }
                    catch (UnknownAttributeException unknownAttributeException) {
                        LOGGER.fatal((Object)unknownAttributeException.getMessage());
                    }
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals(ELEMENT_ELEMENT)) {
                for (Map.Entry<OperatorAttribute, String> entry : this.currentEntry.entrySet()) {
                    Map<OperatorForm, String> map;
                    OperatorAttribute operatorAttribute = entry.getKey();
                    String string4 = entry.getValue();
                    Map<String, Map<OperatorForm, String>> map2 = this.dict.get((Object)operatorAttribute);
                    if (map2 == null) {
                        map2 = new TreeMap<String, Map<OperatorForm, String>>();
                        this.dict.put(operatorAttribute, map2);
                    }
                    if ((map = map2.get(this.currentOperator)) == null) {
                        map = new EnumMap<OperatorForm, String>(OperatorForm.class);
                        map2.put(this.currentOperator, map);
                    }
                    map.put(this.currentFormIndex, string4);
                }
            }
            this.currentEntry = null;
            this.currentOperator = null;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.currentEntry != null) {
                char[] cArray2 = new char[n2];
                System.arraycopy(cArray, n, cArray2, 0, n2);
                this.currentOperator = this.currentOperator == null ? new String(cArray2) : this.currentOperator + new String(cArray2);
                this.currentOperator = this.currentOperator.trim();
            }
        }
    }
}

