/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.util;

import com.dlsc.gemsfx.util.HistoryManager;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javafx.util.StringConverter;
import org.apache.commons.lang3.StringUtils;

public class PreferencesHistoryManager<T>
extends HistoryManager<T> {
    private static final Logger LOG = Logger.getLogger(PreferencesHistoryManager.class.getName());
    public static String DELIMITER = "\u241e";
    private final Preferences preferences;
    private final String key;
    private final StringConverter<T> converter;

    public PreferencesHistoryManager(Preferences preferences, String key, StringConverter<T> converter) {
        this.preferences = Objects.requireNonNull(preferences);
        this.key = Objects.requireNonNull(key);
        this.converter = Objects.requireNonNull(converter);
        this.loadHistory();
    }

    @Override
    protected void storeHistory() {
        String result = this.getAllUnmodifiable().stream().map(arg_0 -> this.converter.toString(arg_0)).collect(Collectors.joining(DELIMITER));
        this.preferences.put(this.key, result);
        LOG.finest(String.format("Stored history items with key: '%s'.", this.key));
    }

    @Override
    protected void loadHistory() {
        String items = this.preferences.get(this.key, "");
        if (StringUtils.isNotEmpty((CharSequence)items)) {
            String[] ary = items.split(DELIMITER);
            this.set(Arrays.stream(ary).map(arg_0 -> this.converter.fromString(arg_0)).toList());
        }
        LOG.finest(String.format("Loaded history items with key: '%s'.", this.key));
    }
}

