/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javassist.CtClass;
import javassist.CtField;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.AccessSpecifier;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.Context;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.MethodUsage;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.UnsolvedSymbolException;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedAnnotationDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedValueDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.LambdaArgumentTypePlaceholder;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.core.resolution.MethodUsageResolutionCapability;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.core.resolution.SymbolResolutionCapability;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistFieldDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistTypeDeclarationAdapter;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistUtils;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.logic.AbstractClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.SymbolSolver;

public class JavassistClassDeclaration
extends AbstractClassDeclaration
implements MethodUsageResolutionCapability,
SymbolResolutionCapability {
    private CtClass ctClass;
    private TypeSolver typeSolver;
    private JavassistTypeDeclarationAdapter javassistTypeDeclarationAdapter;

    public JavassistClassDeclaration(CtClass ctClass, TypeSolver typeSolver) {
        if (ctClass == null) {
            throw new IllegalArgumentException();
        }
        if (ctClass.isInterface() || ctClass.isAnnotation() || ctClass.isPrimitive() || ctClass.isEnum()) {
            throw new IllegalArgumentException("Trying to instantiate a JavassistClassDeclaration with something which is not a class: " + ctClass.toString());
        }
        this.ctClass = ctClass;
        this.typeSolver = typeSolver;
        this.javassistTypeDeclarationAdapter = new JavassistTypeDeclarationAdapter(ctClass, typeSolver, this);
    }

    @Override
    protected ResolvedReferenceType object() {
        return new ReferenceTypeImpl(this.typeSolver.getSolvedJavaLangObject());
    }

    @Override
    public boolean hasDirectlyAnnotation(String canonicalName) {
        return this.ctClass.hasAnnotation(canonicalName);
    }

    @Override
    public Set<ResolvedAnnotationDeclaration> getDeclaredAnnotations() {
        return this.javassistTypeDeclarationAdapter.getDeclaredAnnotations();
    }

    @Override
    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        return this.javassistTypeDeclarationAdapter.getDeclaredMethods();
    }

    @Override
    public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
        return this.javassistTypeDeclarationAdapter.isAssignableBy(other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavassistClassDeclaration that = (JavassistClassDeclaration)o;
        return this.ctClass.equals(that.ctClass);
    }

    public int hashCode() {
        return this.ctClass.hashCode();
    }

    @Override
    public String getPackageName() {
        return this.ctClass.getPackageName();
    }

    @Override
    public String getClassName() {
        String className = this.ctClass.getName().replace('$', '.');
        if (this.getPackageName() != null) {
            return className.substring(this.getPackageName().length() + 1);
        }
        return className;
    }

    @Override
    public String getQualifiedName() {
        return this.ctClass.getName().replace('$', '.');
    }

    @Override
    @Deprecated
    public Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> argumentsTypes, Context invokationContext, List<ResolvedType> typeParameterValues) {
        return JavassistUtils.solveMethodAsUsage(name, argumentsTypes, this.typeSolver, invokationContext, typeParameterValues, this, this.ctClass);
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
        String[] interfaceFQNs;
        for (CtField field : this.ctClass.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return SymbolReference.solved(new JavassistFieldDeclaration(field, typeSolver));
        }
        String superclassFQN = this.getSuperclassFQN();
        SymbolReference<? extends ResolvedValueDeclaration> ref = this.solveSymbolForFQN(name, superclassFQN);
        if (ref.isSolved()) {
            return ref;
        }
        for (String interfaceFQN : interfaceFQNs = this.getInterfaceFQNs()) {
            SymbolReference<? extends ResolvedValueDeclaration> interfaceRef = this.solveSymbolForFQN(name, interfaceFQN);
            if (!interfaceRef.isSolved()) continue;
            return interfaceRef;
        }
        return SymbolReference.unsolved();
    }

    private SymbolReference<? extends ResolvedValueDeclaration> solveSymbolForFQN(String symbolName, String fqn) {
        if (fqn == null) {
            return SymbolReference.unsolved();
        }
        ResolvedReferenceTypeDeclaration fqnTypeDeclaration = this.typeSolver.solveType(fqn);
        return new SymbolSolver(this.typeSolver).solveSymbolInType(fqnTypeDeclaration, symbolName);
    }

    private String[] getInterfaceFQNs() {
        return this.ctClass.getClassFile().getInterfaces();
    }

    private String getSuperclassFQN() {
        return this.ctClass.getClassFile().getSuperclass();
    }

    @Override
    public List<ResolvedReferenceType> getAncestors(boolean acceptIncompleteList) {
        return this.javassistTypeDeclarationAdapter.getAncestors(acceptIncompleteList);
    }

    @Override
    @Deprecated
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        return JavassistUtils.solveMethod(name, argumentsTypes, staticOnly, this.typeSolver, this, this.ctClass);
    }

    public ResolvedType getUsage(Node node) {
        return new ReferenceTypeImpl(this);
    }

    @Override
    public boolean canBeAssignedTo(ResolvedReferenceTypeDeclaration other) {
        ResolvedReferenceType superClass;
        Optional<ResolvedReferenceTypeDeclaration> oDecl;
        if (other instanceof LambdaArgumentTypePlaceholder) {
            return this.isFunctionalInterface();
        }
        if (other.getQualifiedName().equals(this.getQualifiedName())) {
            return true;
        }
        Optional<ResolvedReferenceType> oSuperClass = this.javassistTypeDeclarationAdapter.getSuperClass();
        if (oSuperClass.isPresent() && (oDecl = (superClass = oSuperClass.get()).getTypeDeclaration()).isPresent() && oDecl.get().canBeAssignedTo(other)) {
            return true;
        }
        for (ResolvedReferenceType interfaze : this.javassistTypeDeclarationAdapter.getInterfaces()) {
            if (!interfaze.getTypeDeclaration().isPresent() || !interfaze.getTypeDeclaration().get().canBeAssignedTo(other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAssignableBy(ResolvedType type) {
        return this.javassistTypeDeclarationAdapter.isAssignableBy(type);
    }

    @Override
    public boolean isTypeParameter() {
        return false;
    }

    @Override
    public List<ResolvedFieldDeclaration> getAllFields() {
        return this.javassistTypeDeclarationAdapter.getDeclaredFields();
    }

    @Override
    public String getName() {
        String[] nameElements = this.ctClass.getSimpleName().replace('$', '.').split("\\.");
        return nameElements[nameElements.length - 1];
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public boolean isParameter() {
        return false;
    }

    @Override
    public boolean isType() {
        return true;
    }

    @Override
    public boolean isClass() {
        return !this.ctClass.isInterface();
    }

    @Override
    public Optional<ResolvedReferenceType> getSuperClass() {
        return this.javassistTypeDeclarationAdapter.getSuperClass();
    }

    @Override
    public List<ResolvedReferenceType> getInterfaces() {
        return this.javassistTypeDeclarationAdapter.getInterfaces();
    }

    @Override
    public boolean isInterface() {
        return this.ctClass.isInterface();
    }

    public String toString() {
        return "JavassistClassDeclaration {" + this.ctClass.getName() + '}';
    }

    @Override
    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        return this.javassistTypeDeclarationAdapter.getTypeParameters();
    }

    @Override
    public AccessSpecifier accessSpecifier() {
        return JavassistFactory.modifiersToAccessLevel(this.ctClass.getModifiers());
    }

    @Override
    public List<ResolvedConstructorDeclaration> getConstructors() {
        return this.javassistTypeDeclarationAdapter.getConstructors();
    }

    @Override
    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        return this.javassistTypeDeclarationAdapter.containerType();
    }

    @Override
    public Set<ResolvedReferenceTypeDeclaration> internalTypes() {
        return this.javassistTypeDeclarationAdapter.internalTypes();
    }

    @Override
    public ResolvedReferenceTypeDeclaration getInternalType(String name) {
        Optional type = this.internalTypes().stream().filter((Predicate<ResolvedReferenceTypeDeclaration> & Serializable)f -> f.getName().endsWith(name)).findFirst();
        return (ResolvedReferenceTypeDeclaration)type.orElseThrow((Supplier<UnsolvedSymbolException> & Serializable)() -> new UnsolvedSymbolException("Internal type not found: " + name));
    }

    @Override
    public boolean hasInternalType(String name) {
        return this.internalTypes().stream().anyMatch((Predicate<ResolvedReferenceTypeDeclaration> & Serializable)f -> f.getName().endsWith(name));
    }
}

